/*
 * ---- 
 *
 * $Id: StreamStylesheetEngine.java,v 1.10 2002/02/27 07:41:51 burton Exp $
 * $Project: http://reptile.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/sierra/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 *
 * ----
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 */

package org.openprivacy.reptile.xslt;

import java.io.*;
import java.util.*;

import javax.xml.transform.*;
import javax.xml.transform.dom.*;
import javax.xml.transform.sax.*;
import javax.xml.transform.stream.*;

import org.xml.sax.*;

import org.openprivacy.reptile.cache.sequence.*;
import org.openprivacy.reptile.util.*;
import org.openprivacy.reptile.xml.*;
import org.openprivacy.reptile.xml.serializers.*;

import org.openprivacy.panther.components.*;

import talon.*;
import talon.resources.*;
import talon.util.*;
import talon.util.net.*;

/**
 * @see StylesheetEngine
 * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
 * @version $Id: StreamStylesheetEngine.java,v 1.10 2002/02/27 07:41:51 burton Exp $
 */
public class StreamStylesheetEngine extends BaseStylesheetEngine implements StylesheetEngine {

    /**
     * 
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     */
    public String transform( SequenceDispatchEntry sde ) throws Exception {

        return transform( sde, new ParameterPasser() );

    }
    
    /**
     * Transform the given XML with all the given Stylesheets in the
     * StylesheetStack.  if Talon is in debug mode we will write out temp files
     * for debuging stylesheet output.
     *
     * If the given SequenceDispatchEntry is cacheable this might return content
     * from cache and skip any CPU intensive tasks.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     */
    public String transform( SequenceDispatchEntry sde,
                             ParameterPasser params ) throws Exception {

        //perform any caching with a handle
        SequenceCacheHandle cacheHandle = new SequenceCacheHandle( sde, params );

        SequenceCache cache = SequenceCache.getInstance();

        try {
             
            if ( sde.cacheable() && cache.contains( cacheHandle ) ) {

                Log.debug( "Found content in the sequence cache: " + cacheHandle.toString() );

                String content = cache.fetch( cacheHandle ).getContent();

                cache.incrementCacheHits();
                
                return content;

            }
            
        } catch ( Exception e ) {  } 

        //this is acceptable...
            
        String result = runTransform( sde, params );

        //put this new content back in the cache if necessary.

        if ( sde.cacheable() ) {

            cache.store( cacheHandle, result );

            cache.incrementCacheMisses();
            
        }

        return result;        
        
    }

    /**
     * Physically run a transform and do not perform any caching...
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: StreamStylesheetEngine.java,v 1.10 2002/02/27 07:41:51 burton Exp $
     */
    private String runTransform( SequenceDispatchEntry sde,
                                 ParameterPasser params ) throws Exception {

        Proxy proxy = ReptileResources.getInstance().getProxy();

        Assert.assert( sde.getSkeleton(), "No XML identifier given." );

        XMLReader xmlReader = ReptileParserFactory.getXMLReader();
        
        //xml_source is the XML that is constantly being transformed.
        //get an XML parser with the necessary features disabled.

        InputSource is = new InputSource( proxy.get( sde.getSkeleton() ).getInputStream() );
        
        Source xml_source = new SAXSource( xmlReader, is );
        
        //keep track of what phase number we are on.
        int step = 1;

        StylesheetStack ss = sde.getStylesheetStack();

        StageDumpUtil dumputil = new StageDumpUtil();

        Iterator iterator = ss.getIterator();

        //keep going until we have nore more stylesheets...
        while ( iterator.hasNext() ) {

            //get the stylesheet uri
            URI stylesheetURI = (URI)iterator.next();

            Transformer transformer = ReptileTransformerFactory.getInstance().getTransformer( stylesheetURI );

            transformer.setParameter( ParameterPasser.class.getName(), params );
            
            //Need to pass HTTP parameters into the stylesheet so that these can
            //be accessed.
            setParameters( transformer, params );
            
            ByteArrayOutputStream bos = new ByteArrayOutputStream();

            Result result = new StreamResult( bos );
            
            try { 
                
                transformer.transform( xml_source, result );
                
            } catch ( TransformerException te ) {

                //OK if we have a SAXParseException then we can try to debug
                //line number information.

                //hm.  doesn't look like our TransformerException is giving back a SourceLocator.

                this.error( te, sde, step, stylesheetURI.toString(), params );

            } catch ( Throwable t ) {

                throw new ReptileException( t );
                
            }

            //now we need to use the new XML from the result.

             xml_source = new SAXSource( xmlReader,
                                         new InputSource( new ByteArrayInputStream( bos.toByteArray() ) ) );

            dumputil.dump( sde, bos.toString(), step );
            
            //if we are done just return
            if ( iterator.hasNext() == false )
                return bos.toString();

            ++step;
        } 

        //ug... this should never happen.
        throw new Exception( "No content was generated due to lack of stylesheets." );
        
    }
    
    /**
     * Add all the params in the Hashtable into the Transformer
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: StreamStylesheetEngine.java,v 1.10 2002/02/27 07:41:51 burton Exp $
     */
    private void setParameters( Transformer t, ParameterPasser params ) {

        Enumeration enum = params.keys();

        String name = null;
        String value = null;
        
        while ( enum.hasMoreElements() ) {

            name = (String)enum.nextElement();

            value = (String)params.get( name );

            t.setParameter( name, value );
            
        } 
        
    }

}

