/*
 * ---- 
 *
 * $Id: StageDumpUtil.java,v 1.5 2002/03/09 22:52:24 burton Exp $
 * $Project: http://reptile.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/sierra/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 *
 * ----
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 */

package org.openprivacy.reptile.xslt;

import java.io.*;
import java.net.*;
import java.util.*;

import org.openprivacy.reptile.util.*;

import talon.*;
import talon.resources.*;
import talon.util.*;
import talon.util.net.*;

/**
 * Provides the ability to dump a stage of a sequence to disk.
 *
 * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
 * @version $Id: StageDumpUtil.java,v 1.5 2002/03/09 22:52:24 burton Exp $
 */
public class StageDumpUtil {

    public static final String DUMP_ROOT = System.getProperty( SystemProperties.JAVA_IO_TMPDIR_KEY ) +
                                           "/reptile-sequence-debug/";
    
    //true if we are in debug mode... We obtain this value from Talon..
    boolean debug = TalonResources.getInstance().getTalonPropertyManager()
        .getBoolean( ReptileResources.TALON_LOG_DEBUG_KEY );

    private long currentTimeMillis = System.currentTimeMillis();

    /**
     * Dump output if in debug mode.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: StageDumpUtil.java,v 1.5 2002/03/09 22:52:24 burton Exp $
     */
    public void dump( SequenceDispatchEntry sde,
                      String content,
                      int step ) {

        String key = SystemProperties.REPTILE_SEQUENCE_DEBUG_ENABLED_KEY;
        
        if ( debug && SystemProperties.getBoolean( key ) ) {

            try {

                String filename = DUMP_ROOT + 
                    StringUtils.replaceAll( sde.getName(), "urn:", "urn/" ) +
                    "/" +
                    currentTimeMillis +
                    "/";

                //make this into a filename...
                new File( filename ).mkdirs();
                
                filename = filename + "/step-" + step + ".xml";

                Log.debug( "StylesheetEngine: " + filename, this );
            
                FileOutputStream fos = new FileOutputStream( filename );

                fos.write( content.getBytes() );

                fos.close();

            } catch ( Throwable t ) {

                Log.error( t );

            }
            
        } 
        
    }
    
}
