/*
 * ---- 
 *
 * $Id: SequenceDispatcher.java,v 1.1 2001/12/12 09:29:08 burton Exp $
 * $Project: http://reptile.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/sierra/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 *
 * ----
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 */

package org.openprivacy.reptile.xslt;

import java.io.*;
import java.net.*;
import java.util.*;

import talon.*;
import talon.components.*;
import talon.util.*;
import talon.util.net.*;

import javax.servlet.*;
import javax.servlet.http.*;

import org.openprivacy.reptile.util.*;
import org.openprivacy.reptile.xml.*;

/**
 * Work with the page dispatcher...
 *
 * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
 * @version $Id: SequenceDispatcher.java,v 1.1 2001/12/12 09:29:08 burton Exp $
 */
public class SequenceDispatcher {

    /**
     * Dispatch the given page and output it to the request.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: SequenceDispatcher.java,v 1.1 2001/12/12 09:29:08 burton Exp $
     */
    public static void dispatch( HttpServletRequest request,
                                 HttpServletResponse response,
                                 ParameterPasser params ) throws ServletException {

        //the only different here is that we write to the servlet...
        
        try {

            PrintWriter out = response.getWriter();
            
            out.println( dispatch( params ) );

        } catch ( Throwable t ) {

            Log.error( t );            

            throw new ServletException( t.getMessage() );

        }

    }

    /**
     * 
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: SequenceDispatcher.java,v 1.1 2001/12/12 09:29:08 burton Exp $
     */
    public static String dispatch( ParameterPasser params ) throws Exception {

        String sequenceName = (String)params.get( "reptile.sequence.name" );

        Assert.assert( sequenceName, "Sequence name may not be null." );
        
        SequenceDispatchHandler sdh = new SequenceDispatchHandler( sequenceName, params );

        return sdh.dispatch();
        
    }

    /**
     * 
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: SequenceDispatcher.java,v 1.1 2001/12/12 09:29:08 burton Exp $
     */
    public static String dispatch( String sequenceName,
                                   ParameterPasser params ) throws Exception {

        Assert.assert( sequenceName, "Sequence name may not be null." );
        Assert.assert( params, "Can not use null parameters" );
        
        params.put( "reptile.sequence.name", sequenceName );

        return dispatch( params );

    }
    
    /**
     * 
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: SequenceDispatcher.java,v 1.1 2001/12/12 09:29:08 burton Exp $
     */
    public static void dispatch( HttpServletRequest request,
                                 HttpServletResponse response,
                                 String sequenceName ) throws ServletException {

        Assert.assert( sequenceName, "Sequence name may not be null." );
        
        ParameterPasser params = new ParameterPasser( request, response, sequenceName );
        
        dispatch( request, response, params );        

    }
    
}
