/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $ID: PantherProxy.java,v 1.6 2001/06/12 20:58:43 burton Exp $
 * $Project: http://panther.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/panther/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * ---- 
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 * 
 */

package org.openprivacy.reptile.xslt;

import java.io.*;
import java.util.*;

import org.xml.sax.*;
import org.xml.sax.helpers.*;

import org.openprivacy.panther.components.*;

import talon.*;
import talon.util.*;
import talon.util.net.*;

import org.openprivacy.reptile.*;
import org.openprivacy.reptile.util.*;

/**
 * Representation of a sequence entry that we would find in
 * sequence-dispatch.xml.
 *
 * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
 * @version $Id: SequenceDispatchEntry.java,v 1.3 2002/08/26 06:43:30 burton Exp $
 */
public class SequenceDispatchEntry {
    
    /**
     * The location is the URL of the content being rendered.  in some
     * situations this may be identical to the skeleton... in some it may not.
     *
     */
    private String location = "";
    
    private StylesheetStack stylesheetStack = new StylesheetStack();

    private String skeleton = null;    

    private String name = null;    

    private String parent = null;    

    /**
     * Don't cache by default.
     */
    private boolean cacheable = false;

    /**
     * 
     * Create a new <code>SequenceDispatchEntry</code> instance.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: SequenceDispatchEntry.java,v 1.3 2002/08/26 06:43:30 burton Exp $
     */
    public SequenceDispatchEntry( String name ) {
        
        this.name = name;
        
    }

    
    /**
     * 
     * Get the value of <code>parent</code>.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: SequenceDispatchEntry.java,v 1.3 2002/08/26 06:43:30 burton Exp $
     */
    public String getParent() { 
        
        return this.parent;
        
    }

    /**
     * 
     * Set the value of <code>parent</code>.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: SequenceDispatchEntry.java,v 1.3 2002/08/26 06:43:30 burton Exp $
     */
    public void setParent( String parent ) { 
        
        this.parent = parent;
        
    }


    /**
     * 
     * Get the value of <code>skeleton</code>.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: SequenceDispatchEntry.java,v 1.3 2002/08/26 06:43:30 burton Exp $
     */
    public String getSkeleton() { 
        
        return this.skeleton;
        
    }

    /**
     * 
     * Set the value of <code>skeleton</code>.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: SequenceDispatchEntry.java,v 1.3 2002/08/26 06:43:30 burton Exp $
     */
    public void setSkeleton( String skeleton ) { 
        
        this.skeleton = skeleton;
        
    }

    /**
     * 
     * Get the value of <code>name</code>.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: SequenceDispatchEntry.java,v 1.3 2002/08/26 06:43:30 burton Exp $
     */
    public String getName() { 
        
        return this.name;
        
    }

    /**
     * 
     * Set the value of <code>name</code>.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: SequenceDispatchEntry.java,v 1.3 2002/08/26 06:43:30 burton Exp $
     */
    public void setName( String name ) { 
        
        this.name = name;
        
    }

    /**
     * 
     * Get the StylesheetStack.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: SequenceDispatchEntry.java,v 1.3 2002/08/26 06:43:30 burton Exp $
     */
    public StylesheetStack getStylesheetStack() { 
        
        return this.stylesheetStack;
        
    }

    /**
     * 
     * Set the StylesheetStack
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: SequenceDispatchEntry.java,v 1.3 2002/08/26 06:43:30 burton Exp $
     */
    public void setStylesheetStack( StylesheetStack stylesheetStack ) { 
        
        this.stylesheetStack = stylesheetStack;
        
    }

    /**
     * Return true if this is cacheable.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: SequenceDispatchEntry.java,v 1.3 2002/08/26 06:43:30 burton Exp $
     */
    public boolean cacheable() {

        return this.cacheable;
        
    }

    /**
     * @see #cacheable
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: SequenceDispatchEntry.java,v 1.3 2002/08/26 06:43:30 burton Exp $
     */
    public void setCacheable( boolean cacheable ) {

        this.cacheable = cacheable;
        
    }

    /**
     * @see Object#equals
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: SequenceDispatchEntry.java,v 1.3 2002/08/26 06:43:30 burton Exp $
     */
    public boolean equals( Object obj ) {

        if ( this.getClass() == obj.getClass() ) {

            SequenceDispatchEntry other = (SequenceDispatchEntry)obj;

            return getSkeleton().equals( other.getSkeleton() ) &&
                   getName().equals( other.getName() ) &&
                   getStylesheetStack().equals( other.getStylesheetStack() ) &&
                   getLocation().equals( other.getLocation() );
        }

        return false;

    }
    
    /**
     * @see Object#hashCode
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: SequenceDispatchEntry.java,v 1.3 2002/08/26 06:43:30 burton Exp $
     */
    public int hashCode() {

        return getName().hashCode() +
               getSkeleton().hashCode() +
               getStylesheetStack().hashCode() +
               getLocation().hashCode();

    }

    /**
     * 
     * Get the value of <code>location</code>.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public String getLocation() { 
        
        return this.location;
        
    }

    /**
     * 
     * Set the value of <code>location</code>.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public void setLocation( String location ) { 
        
        this.location = location;
        
    }

    
}
