/*
 * ---- 
 *
 * $Id: DOMStylesheetEngine.java,v 1.6 2002/02/21 22:41:24 burton Exp $
 * $Project: http://reptile.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/sierra/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 *
 * ----
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 */

package org.openprivacy.reptile.xslt;

import java.io.*;
import java.util.*;

import javax.xml.transform.*;
import javax.xml.transform.stream.*;
import javax.xml.transform.sax.*;
import javax.xml.transform.dom.*;

import javax.xml.parsers.*;

import org.xml.sax.*;

import org.openprivacy.reptile.xml.*;
import org.openprivacy.reptile.util.*;
import org.openprivacy.reptile.cache.sequence.*;

import org.openprivacy.panther.components.*;

import talon.*;
import talon.resources.*;
import talon.util.*;
import talon.util.net.*;

import org.apache.xalan.serialize.*;

/**
 * Given an XML document and a StylesheetStack this will use TRAX to transform
 * all the content.
 *
 * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
 * @version $Id: DOMStylesheetEngine.java,v 1.6 2002/02/21 22:41:24 burton Exp $
 */
public class DOMStylesheetEngine implements StylesheetEngine {

    private static DOMStylesheetEngine instance = null;

    /**
     * Get an instance of the DOMStylesheetEngine.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: DOMStylesheetEngine.java,v 1.6 2002/02/21 22:41:24 burton Exp $
     */
    public static DOMStylesheetEngine getInstance() {

        if ( instance == null) {

            instance = new DOMStylesheetEngine();
            
        } 
        
        return instance;
        
    }

    /**
     * 
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: DOMStylesheetEngine.java,v 1.6 2002/02/21 22:41:24 burton Exp $
     */
    public String transform( SequenceDispatchEntry sde ) throws Exception {

        return transform( sde, new ParameterPasser() );

    }
    
    /**
     * Transform the given XML with all the given Stylesheets in the
     * StylesheetStack.  if Talon is in debug mode we will write out temp files
     * for debuging stylesheet output.
     *
     * If the given SequenceDispatchEntry is cacheable this might return content
     * from cache and skip any CPU intensive tasks.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: DOMStylesheetEngine.java,v 1.6 2002/02/21 22:41:24 burton Exp $
     */
    public String transform( SequenceDispatchEntry sde,
                             ParameterPasser params ) throws Exception {

        //perform any caching with a handle
        SequenceCacheHandle cacheHandle = new SequenceCacheHandle( sde, params );

        SequenceCache cache = SequenceCache.getInstance();

        try {
             
            if ( sde.cacheable() && cache.contains( cacheHandle ) ) {

                Log.debug( "Found content in the sequence cache: " + cacheHandle.toString() );

                String content = cache.fetch( cacheHandle ).getContent();

                cache.incrementCacheHits();
                
                return content;

            }
            
        } catch ( Exception e ) {  } 

        //this is acceptable...
            
        String result = runTransform( sde, params );

        //put this new content back in the cache if necessary.

        if ( sde.cacheable() ) {

            cache.store( cacheHandle, result );

            cache.incrementCacheMisses();
            
        }

        return result;        
        
    }

    /**
     * Physically run a transform and do not perform any caching...
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: DOMStylesheetEngine.java,v 1.6 2002/02/21 22:41:24 burton Exp $
     */
    private String runTransform( SequenceDispatchEntry sde,
                                 ParameterPasser params ) throws Exception {

        Proxy proxy = ReptileResources.getInstance().getProxy();

        Assert.assert( sde.getSkeleton(), "No skeleton given in SequenceDispatchEntry" );

        XMLReader xmlReader = ReptileParserFactory.getXMLReader();
        
        //xml_source is the XML that is constantly being transformed.
        //get an XML parser with the necessary features disabled.

        //Source xsource = new StreamSource( proxy.get( sde.getSkeleton() ).getInputStream() );

        //

        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating( false );
        dbf.setNamespaceAware( true );

        DocumentBuilder builder = dbf.newDocumentBuilder();
        
        Source xsource = new DOMSource( builder.parse( proxy.get( sde.getSkeleton() ).getInputStream() ));
        
        //keep track of what phase number we are on.
        int step = 1;

        StylesheetStack ss = sde.getStylesheetStack();

        StageDumpUtil dumputil = new StageDumpUtil();

        Iterator iterator = ss.getIterator();

        //keep going until we have nore more stylesheets...
        while ( iterator.hasNext() ) {

            //get the stylesheet uri for this round
            URI stylesheetURI = (URI)iterator.next();

            System.out.println( " FIXME: (debug): using stylesheetURI: " + stylesheetURI.toString() );
            
            //get a template for this round.
            Transformer transformer = ReptileTransformerFactory.getInstance().getTransformer( stylesheetURI );

            //set the ParameterPasser in this Transformer.
            transformer.setParameter( ParameterPasser.class.getName(), params );
            
            //Need to pass HTTP parameters into the stylesheet so that these can
            //be accessed.
            this.setParametersInTransformer( transformer, params );
            
            //if we are done just return
            if ( iterator.hasNext() == false ) {

                //last leg of the journey, use a StreamResult so that we can output right away.

                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                
                StreamResult result = new StreamResult( bos );

                transformer.transform( xsource, result );

                String sresult = bos.toString();
                
                dumputil.dump( sde, sresult, step );
                
                return sresult;
                
            } else {

                //use a DOMResult for the next leg of the journey.
                
                //DOMResult result = new DOMResult(  );

                org.w3c.dom.Node nResult = new org.apache.xerces.dom.DocumentImpl();
                
                DOMResult result = new DOMResult( nResult );

                result.setNode( nResult );

                System.out.println( " FIXME: ( debug ): within step number... " + step );                
                
                transformer.transform( xsource, result );

                //prepare the XMLSource for the next round...

                xsource = new DOMSource( nResult, stylesheetURI.toString() );

                dumputil.dump( sde, serialize( result), step );

            }

            ++step;
        } 

        //THIS SHOULD NEVER HAPPEN.
        throw new Exception( "No content was generated due to lack of stylesheets." ); 
        
    }

    /**
     * Given a DOMResult, serialize it to a string, used for dumping debug
     * information to disk
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton - burtonator</a>
     */
    private String serialize( DOMResult dom_result ) throws Exception {

        SerializerToXML stx = new SerializerToXML();

        ByteArrayOutputStream bos = new ByteArrayOutputStream();

        stx.setOutputStream( bos );

        DOMSerializer ds = stx.asDOMSerializer();

        ds.serialize( dom_result.getNode() );

        //stx.flush();
        //stx.close();
        
        String result = bos.toString();

        return result;
        
    }
    
    /**
     * Add all the params in the Hashtable into the Transformer
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: DOMStylesheetEngine.java,v 1.6 2002/02/21 22:41:24 burton Exp $
     */
    private void setParametersInTransformer( Transformer t, ParameterPasser params ) {

        Enumeration enum = params.keys();

        String name = null;
        String value = null;
        
        while ( enum.hasMoreElements() ) {

            name = (String)enum.nextElement();

            value = (String)params.get( name );

            t.setParameter( name, value );
            
        } 
        
    }

}

