/*
 * ---- 
 *
 * $Id: BaseStylesheetEngine.java,v 1.3 2002/02/27 07:41:51 burton Exp $
 * $Project: http://reptile.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/sierra/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 *
 * ----
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 */

package org.openprivacy.reptile.xslt;

import java.io.*;
import java.net.*;
import java.util.*;

import javax.xml.transform.*;
import javax.xml.transform.stream.*;
import javax.xml.transform.sax.*;
import javax.xml.transform.dom.*;

import org.xml.sax.*;
import org.xml.sax.helpers.*;

import org.openprivacy.reptile.xml.*;
import org.openprivacy.reptile.util.*;
import org.openprivacy.reptile.cache.sequence.*;

import org.openprivacy.panther.components.*;

import talon.*;
import talon.resources.*;
import talon.util.*;
import talon.util.net.*;

import javax.xml.transform.sax.*;

/**
 * Provides base functionality for all StylesheetEngines (which want to use
 * them).
 *
 * @version $Id: BaseStylesheetEngine.java,v 1.3 2002/02/27 07:41:51 burton Exp $
 */
public abstract class BaseStylesheetEngine implements StylesheetEngine {

    /**
     * 
     * <p>
     * If Reptile throws a SAXParseException while parsing we need to handle this!!!
     * 
     * <p>
     * We need a VERY stable way for producing and debugging XML/XSL error.  Everytime
     * se whould get a dump like the following:
     *
     * <pre>
     * --------------------------------------------------------------------------------
     * ****************** A StylesheetEngine problem has occured  *********************
     * --------------------------------------------------------------------------------
     * 
     * In StylesheetEngine: org.openprivacy.reptile.xslt.StreamStylesheetEngine
     * In sequence: urn:search/channels
     * During step: 2
     * In stylesheet: resource:/xsl/misc/mozilla/page.xsl
     * On line: 660
     * On column: 28
     * Public ID:
     * System ID: 
     * With exception classname: org.sax.SAXParserException
     * With exception message: invalid UTF-8 character
     * XML source is now stored in:  file:///tmp/test.txt
     * 
     * --------------------------------------------------------------------------------
     * </pre>
     * 
     * <p>
     * This step should ALSO override any settings we have in dumping... AKA it should
     * ALWAYS dump here.  
     *
     * <p>
     * This should be shared code for debugging this.  We should be able to use this
     * independent on the implementation.
     * 
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    protected void error( TransformerException te,
                          SequenceDispatchEntry sde,
                          int step,
                          String stylesheet,
                          ParameterPasser params ) {

        StringBuffer error = new StringBuffer();
        
        error.append( "--------------------------------------------------------------------------------\n" );
        error.append( "******************* A StylesheetEngine problem has occured  ********************\n" );
        error.append( "--------------------------------------------------------------------------------\n\n" );
        error.append( "In StylesheetEngine: " + getClass().getName() + "\n" );
        error.append( "In sequence: " + sde.getName()  + "\n" );
        error.append( "In skeleton: " + sde.getSkeleton()  + "\n" );
        error.append( "At location: " + sde.getLocation()  + "\n" );
        error.append( "During step: " + step  + "\n" );
        error.append( "In stylesheet: " + stylesheet  + "\n" );

        //now dump the params

        error.append( " -- BEGIN params -- \n" );
        
        Enumeration enum = params.keys();

        while ( enum.hasMoreElements() ) {

            String key = (String)enum.nextElement();

            String value = params.getString( key );

            error.append( key + " == " + value + "\n" );
            
        } 
        
        error.append( " -- END params -- \n" );
        
        //ok... now debug  the location

        Throwable cause = te.getCause();

        if ( cause == null ) {

            error.append( "cause is null"  + "\n" );

        } else if ( cause instanceof SAXParseException ) {

            SAXParseException spe = (SAXParseException)cause;

            error.append( "On line: " + spe.getLineNumber()  + "\n" );
            error.append( "On column: " + spe.getColumnNumber()  + "\n" );
            error.append( "System ID: " + spe.getSystemId()  + "\n" );
            error.append( "Public ID: " + spe.getPublicId()  + "\n" );

        } else {

            error.append( "With Exception cause classname: " + cause.getClass().getName()  + "\n" );

            error.append( "With Exception cause message: " + cause.getMessage()  + "\n" );

            error.append( "Unable to determine line numbers"  + "\n" );

        }

        error.append( "--------------------------------------------------------------------------------"  + "\n" );

        //so that we can print this to the error stream WITHOUT overlapping lines.
        synchronized( System.err ) {

            synchronized( System.out ) {

                System.err.println( error.toString() );

                te.printStackTrace();

            }
            
        }
        
    }
    
}

