/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $ID: PantherProxy.java,v 1.6 2001/06/12 20:58:43 burton Exp $
 * $Project: http://panther.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/panther/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * ---- 
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have received with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 * 
 */

package org.openprivacy.reptile.xml.serializers;

import java.io.*;
import java.net.*;
import java.util.*;

import talon.*;
import talon.components.*;
import talon.util.*;
import talon.util.net.*;

import org.openprivacy.reptile.*;
import org.openprivacy.reptile.util.*;
import org.openprivacy.reptile.xml.*;

import org.jdom.*;
import org.jdom.output.*;

/**
 * Handles serializing an Error into XML.
 *
 * Example output:
 * 
 * <error xmlns="http://schemas.openprivacy.org/reptile/errors" type="exception">
 * 
 * An error has occured.
 * 
 * </error>
 * 
 * 
 * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
 * @version $Id: ErrorXMLSerializer.java,v 1.8 2002/02/27 07:41:50 burton Exp $
 */
public class ErrorXMLSerializer {
    
    private String message = null;
    
    private Throwable throwable;

    /**
     * 
     * Create a new <code>ErrorXMLSerializer</code> instance.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: ErrorXMLSerializer.java,v 1.8 2002/02/27 07:41:50 burton Exp $
     */
    public ErrorXMLSerializer( Throwable throwable ) {
        
        this.throwable = throwable;
        
    }

    /**
     * 
     * Create a new <code>ErrorXMLSerializer</code> instance.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public ErrorXMLSerializer( String message ) {
        
        this.message = message;
        
    }
    
    /**
     * Serialize this to a string.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: ErrorXMLSerializer.java,v 1.8 2002/02/27 07:41:50 burton Exp $
     */
    public Element serialize() {

        //FIXME: use JDom for this!
        
        Namespace namespace = Namespace.getNamespace( "error",
                                                      ReptileResources.ERROR_NAMESPACE );

        Element error = new Element( "error", namespace );

        error.setAttribute( "type", "exception" );
        
        String message = throwable.getMessage();

        if ( message == null ) {
            //use the provided message.
            message = this.message;
        } 
        
        
        if ( message == null )
            message = "No message provided.";

        error.addContent( new CDATA( XMLEncoder.encode( message ) ) );

        //get the stacktrace.

        //          Element stacktrace = new Element( "stacktrace", namespace );

        //          ByteArrayOutputStream bos = new ByteArrayOutputStream();

        //          stacktrace.addContent( new CDATA( XMLEncoder.encode( bos.toString() ) ) );

        //          error.addContent( stacktrace );

        return error;
        
    }

    /**
     * 
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public String serializeAsString() {

        XMLOutputter outputter = new XMLOutputter();

        outputter.setEncoding( ReptileResources.DEFAULT_XML_ENCODING );
        
        String result = outputter.outputString( serialize() );

        Log.error( result );
        
        return result;

    }

    /**
     * 
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public org.w3c.dom.Node serializeAsNode() {

        try { 
            
            return new DOMOutputter().output( serialize() );
            
        } catch ( Throwable t ) {

            Log.error( t );

            return null;
                
        }

    }

    /**
     * 
     * Get the value of <code>message</code>.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public String getMessage() { 
        
        return this.message;
        
    }

    /**
     * 
     * Set the value of <code>message</code>.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public void setMessage( String message ) { 
        
        this.message = message;
        
    }

    
}
