/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $ID: PantherProxy.java,v 1.6 2001/06/12 20:58:43 burton Exp $
 * $Project: http://panther.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/panther/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * ---- 
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have received with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 * 
 */

package org.openprivacy.reptile.xml;

import java.io.*;
import java.util.*;

import org.xml.sax.*;
import org.xml.sax.helpers.*;

import org.openprivacy.panther.components.*;

import talon.*;
import talon.util.*;
import talon.util.net.*;

import org.openprivacy.reptile.*;
import org.openprivacy.reptile.util.*;

/**
 * Handles parsing out the users XML file 
 * 
 * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
 * @version $Id: SubscriptionsLocationHandler.java,v 1.5 2001/09/29 23:32:02 burton Exp $
 */
public class SubscriptionsLocationHandler extends DefaultHandler {


    private Vector locations = new Vector( 100 );

    private Hashtable contentTypes = new Hashtable();
    
    private Proxy proxy = null;
    
    /**
     *
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     */
    public SubscriptionsLocationHandler( URI subscriptions ) throws ReptileException {

        try {

            this.proxy = ReptileResources.getInstance().getProxy();
            
            XMLReader xmlr = ReptileParserFactory.getXMLReader();

            xmlr.setContentHandler( this );
        
            xmlr.parse( new InputSource( proxy.get( subscriptions ).getInputStream() ) );
            
        } catch ( Exception e) {

            throw new ReptileException( e );
            
        } 
        
    }
    
    /**
     * 
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     */
    public void startElement( String uri,
                              String local,
                              String raw,
                              Attributes attrs ) {

        if ( uri.equals( ReptileResources.LAYOUT_NAMESPACE ) &&
             local.equals( "content" ) ) {

            String location = attrs.getValue( "location" );
            String contentType = attrs.getValue( "contentType" );

            this.contentTypes.put( location, contentType );

            URI location_uri = new URI( location );

            if ( proxy.supports( new URI( location ) ) ) {
                
                this.locations.addElement( location );
                
            } 
            
        } 
        
    } 


    /**
     * Get the URLs this handler found.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: SubscriptionsLocationHandler.java,v 1.5 2001/09/29 23:32:02 burton Exp $
     */
    public String[] getLocations() {

        String[] found = new String[ locations.size() ];
        locations.copyInto( found );

        return found;
        
    }

    /**
     * 
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     */
    public String getContentType( String location ) {

        return (String)contentTypes.get( location );
        
    }
    
}
