/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $ID: PantherProxy.java,v 1.6 2001/06/12 20:58:43 burton Exp $
 * $Project: http://panther.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/panther/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * ---- 
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have received with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 * 
 */

package org.openprivacy.reptile.xml;

import java.io.*;
import java.util.*;

import talon.*;

import org.openprivacy.reptile.*;
import org.openprivacy.reptile.util.*;

import org.jdom.*;
import org.jdom.input.*;

import org.jaxen.jdom.*;
import org.jaxen.*;

/**
 * Used to abstract the use of Jaxen XPath.  Internally this can use whatever
 * parser we want, DOM4J, JDOM, DOM, whatever.
 *
 * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
 * @version $Id: ReptileXPath.java,v 1.4 2002/02/08 01:05:52 burton Exp $
 */
public class ReptileXPath {

    private Document document = null;

    private XPath xpath = null;
    
    /**
     * 
     * Create a new <code>ReptileXPath</code> instance.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public ReptileXPath( String content, String xpath_expression ) throws Exception {

        SAXBuilder builder = new SAXBuilder();
        
        this.document = builder.build( new StringReader( content ) );
        
        this.xpath = new XPath( xpath_expression );

    }

    /**
     * Select a multiple nodes with this expression.
     * 
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public List selectNodes() throws Exception {

        return xpath.selectNodes( document );
        
    }

    /**
     * Select a single node with this expression.  What type of object that this
     * returns may change depending on your XPath query.  If it is an element
     * query it will return an JDOM Element.  If it is an attribute query it
     * will return a JDOM Attribute.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public Object selectSingleNode() throws Exception {

        return xpath.selectSingleNode( document );

    }

    /**
     * 
     * @see XPath#addNamespace
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public void addNamespace( String prefix, String uri ) throws Exception {

        xpath.addNamespace( prefix, uri );
        
    }

    /**
     * Assert that the given expression, in the given content, equals the given
     * value.  Internally this uses selectSingleNode.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public static void assertXPathNodes( String content,
                                         String expression ) throws Exception {

        System.out.println( content );
        
        ReptileXPath xpath = getReptileXPath( content, expression );

        List result = xpath.selectNodes();

        if ( result.size() == 0 ) {

            System.out.println( content );

            throw new Exception( "Didn't find any results for query: " + expression );
        } 

    }
        
    /**
     * Assert that the given expression, in the given content, equals the given
     * value.  Internally this uses selectSingleNode.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public static void assertXPath( String content,
                                    String expression,
                                    String value ) throws Exception {

        ReptileXPath xpath = getReptileXPath( content, expression );
        
        Object result = xpath.selectSingleNode();

        if ( result instanceof Attribute ) {
            
            Attribute attr = (Attribute)result;

            if ( attr.getValue().equals( value ) == false )
                throw new Exception( "XPath expression not equal: " + attr.getValue() + " != " + value );
            
        } else if ( result instanceof Element ) {

            Element elem = (Element)result;

            if ( elem.getText().equals( value ) == false )
                throw new Exception( "XPath expression not equal: " + elem.getText() + " != " + value );

        } else {

            throw new Exception( "Invalid result: " + result );
            
        }

    }

    /**
     * Assert that the given expression, in the given content, equals the given
     * value.  Internally this uses selectSingleNode.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public static void assertXPathNotEqual( String content,
                                            String expression,
                                            String value ) throws Exception {

        ReptileXPath xpath = getReptileXPath( content, expression );
        
        Object result = xpath.selectSingleNode();

        if ( result instanceof Attribute ) {
            
            Attribute attr = (Attribute)result;

            String avalue = attr.getValue();
            
            if ( avalue.equals( value ) == true || avalue == null )
                throw new Exception( "XPath expression equal: " + attr.getValue() + " != " + value );
            
        } else if ( result instanceof Element ) {

            Element elem = (Element)result;

            String text = elem.getText();
            
            if ( text.equals( value ) == true || text == null )
                throw new Exception( "XPath expression equal: " + elem.getText() + " != " + value );

        } else {

            throw new Exception( "Invalid result: " + result );
            
        }

    }

    /**
     * 
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    private static ReptileXPath getReptileXPath( String content, String expression ) throws Exception {

        ReptileXPath xpath = new ReptileXPath( content, expression );

        xpath.addNamespace( "search", ReptileResources.SEARCH_NAMESPACE );
        xpath.addNamespace( "rss", ReptileResources.RSS_1_0_NAMESPACE );
        xpath.addNamespace( "rdf", ReptileResources.RDF_NAMESPACE );

        return xpath;
        
    }
    
}
