/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $ID: PantherProxy.java,v 1.6 2001/06/12 20:58:43 burton Exp $
 * $Project: http://panther.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/panther/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * ---- 
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have received with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 * 
 */

package org.openprivacy.reptile.xml;

import java.io.*;
import java.util.*;

import org.xml.sax.*;
import org.xml.sax.helpers.*;

import talon.*;
import talon.util.*;
import talon.util.net.*;

import org.openprivacy.reptile.*;
import org.openprivacy.reptile.util.*;

/**
 * Responsible for creating XML parsers and enabling/disabling any necessary
 * features.  This should be used within Reptile to get an XML parser.
 * 
 * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
 * @version $Id: ReptileParserFactory.java,v 1.8 2002/02/23 10:42:53 burton Exp $
 */
public class ReptileParserFactory {

    /**
     * 
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: ReptileParserFactory.java,v 1.8 2002/02/23 10:42:53 burton Exp $
     */
    public static XMLReader getXMLReader() throws SAXException {
    
        //FIXME: is it possible to cache/pool XMLReaders??

        XMLReader xmlr = XMLReaderFactory.createXMLReader( ReptileResources.PARSER );    

        setFeatures( xmlr );
        
        return xmlr;
        
    }

    /**
     * Set features on this parser.  The general goal here is to parse FAST
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: ReptileParserFactory.java,v 1.8 2002/02/23 10:42:53 burton Exp $
     */
    private static void setFeatures( XMLReader reader ) throws SAXException {

        reader.setFeature( "http://xml.org/sax/features/validation", false );

        reader.setFeature( "http://apache.org/xml/features/validation/schema", false );

        //FIXME: Is this supported in Xerces 1.4.2???  It looks like it is not
        //(because we get SAXNotSupportedExceptions).  When these features are
        //disabled we see s significant performance upgrade.  Stick with Xerces
        //1.4.1 for the time being so that we can disable these.
        
        reader.setFeature( "http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false );

        reader.setFeature( "http://apache.org/xml/features/nonvalidating/load-external-dtd", false );
        
    }
    
}
