/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $ID: PantherProxy.java,v 1.6 2001/06/12 20:58:43 burton Exp $
 * $Project: http://panther.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/panther/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * ---- 
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have received with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 * 
 */


package org.openprivacy.reptile.xml;

import java.io.*;
import java.util.*;

import org.xml.sax.*;
import org.xml.sax.helpers.*;

import org.openprivacy.panther.components.*;

import talon.*;
import talon.util.*;
import talon.util.net.*;

import org.openprivacy.reptile.*;
import org.openprivacy.reptile.util.*;
import org.openprivacy.reptile.xslt.*;

/**
 * Responsible for parsing out the content-transformer.xml file so that we can
 * find content maps.
 * 
 * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
 * @version $Id: ContentTransformerHandler.java,v 1.13 2002/02/27 07:41:50 burton Exp $
 */
public class ContentTransformerHandler extends DefaultHandler {
    
    private String skeleton = null;

    public static final URI xml = new URI( "resource:/xml/content-transformer.xml" );

    private StylesheetStack ss = new StylesheetStack();

    private String inputFormat = "";
    private String outputFormat = "";

    
    //parse level variables

    private String currentInputFormat = "";

    private String currentOutputFormat = "";
    
    /**
     *
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: ContentTransformerHandler.java,v 1.13 2002/02/27 07:41:50 burton Exp $
     */
    public ContentTransformerHandler( String inputFormat,
                                      String outputFormat ) throws ReptileException {

        this.inputFormat = inputFormat;

        this.outputFormat = outputFormat;
                

        try {

            //FIXME: on't parse very time...

            Proxy proxy = ReptileResources.getInstance().getProxy();

            Log.debug( "ContentTransformerHandler is parsing... " );

            XMLReader xmlr = ReptileParserFactory.getXMLReader();

            xmlr.setContentHandler( this );

            xmlr.parse( new InputSource( proxy.get( xml ).getInputStream() ) );
            
        } catch ( Exception e) {

            Log.error( e );
            
            throw new ReptileException( e );
            
        } 
        
    }
    
    public void startElement( String uri,
                              String local,
                              String raw,
                              Attributes attrs ) {

        //only operate on the correct namespace.
        if ( uri.equals( ReptileResources.CONTENT_TRANSFORMER_NAMESPACE ) ) {

            //find sequences...
            if ( local.equals( "map" ) ) {

                this.currentInputFormat = attrs.getValue( "inputFormat" );
                this.currentOutputFormat = attrs.getValue( "outputFormat" );
                
            } 

            //process stylesheets.
            if ( local.equals( "stylesheet" ) &&
                 currentInputFormat.equals( inputFormat ) &&
                 currentOutputFormat.equals( outputFormat ) ) {

                String stylesheet = attrs.getValue( "location" );

                ss.addStylesheet( stylesheet );

            }

            //process stylesheets.
            if ( local.equals( "skeleton" ) &&
                 currentInputFormat.equals( inputFormat ) &&
                 currentOutputFormat.equals( outputFormat ) ) {

                String skeleton = attrs.getValue( "location" );

                this.setSkeleton( skeleton );

            }
            
        } 
        
    } 
    
    /**
     * Get the stack that this map wants to use.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: ContentTransformerHandler.java,v 1.13 2002/02/27 07:41:50 burton Exp $
     */
    public StylesheetStack getStylesheetStack() {

        return this.ss;

    }

    /**
     * 
     * Get the value of <code>skeleton</code>.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public String getSkeleton() { 
        
        return this.skeleton;
        
    }

    /**
     * 
     * Set the value of <code>skeleton</code>.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public void setSkeleton( String skeleton ) { 
        
        this.skeleton = skeleton;
        
    }


    
}
