/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $ID: PantherProxy.java,v 1.6 2001/06/12 20:58:43 burton Exp $
 * $Project: http://panther.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/panther/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * ---- 
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have received with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 * 
 */

package org.openprivacy.reptile.util;

import java.net.*;
import java.io.*;
import java.util.*;

import org.openprivacy.panther.components.*;

import talon.util.net.*;
import talon.components.*;
import talon.*;

/**
 * Contains important Reptile system properties.
 *
 * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
 * @version $Id: SystemProperties.java,v 1.7 2002/07/04 20:35:04 burton Exp $
 */
public class SystemProperties {

    public static final String REPTILE_SYSTEM_FEEDS_DISABLED_KEY = 
        "reptile.system.feeds.disabled";

    public static final String REPTILE_SYSTEM_TASKS_DISABLED_KEY = 
        "reptile.system.tasks.disabled";

    public static final String REPTILE_SEQUENCE_DEBUG_ENABLED_KEY
        = "reptile.sequence.debug.enabled";

    public static final String REPTILE_SYSTEM_INITIALIZED_KEY
        = "reptile.system.initialized";

    public static final String REPTILE_SYSTEM_RESTARTED_KEY
        = "reptile.system.restarted";

    public static final String JAVA_IO_TMPDIR_KEY = "java.io.tmpdir";

    public static final String REPTILE_TASKS_MAX_TASK_THREADS_KEY = 
        "reptile.tasks.max-task-threads";

    public static final String REPTILE_JXTA_ENABLED_KEY = 
        "reptile.jxta.enabled";

    public static final String REPTILE_JXTA_PEERGROUP_ID_KEY = 
        "reptile.jxta.peergroup.id";

    public static final String REPTILE_JXTA_PEERGROUP_NAME_KEY = 
        "reptile.jxta.peergroup.name";
    
    public static final String REPTILE_JXTA_PEERGROUP_DESCRIPTION_KEY = 
        "reptile.jxta.peergroup.description";

    public static final String REPTILE_JXTA_STARTUP_SHELL_KEY = 
        "reptile.jxta.startup-shell";

    public static final String REPTILE_SEQUENCE_DEFAULT_KEY = 
        "reptile.sequence.default";

    public static final String PANTHER_LINK_TYPE_KEY = 
        "panther.link-type";

    public static final String PANTHER_ROOT_KEY = 
        "panther.root";

    public static final String REPTILE_OPERATION_MODE_KEY = 
        "reptile.operation.mode";

    /**
     * Get a system property as an integer.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public static int getInteger( String key, int def ) {

        String value = System.getProperty( key );

        if ( value == null )
            return def;
        
        return Integer.parseInt( value );
        
    }

    /**
     * Get a boolean system property.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public static boolean getBoolean( String key ) {

        String value = System.getProperty( key );

        //always false if it is null
        if ( value == null )
            return false;

        return value.equals( "true" );
        
    }

    /**
     * Basically a synonym for System.getProperty()
     *
     * @see System#getProperty
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public static String getString( String key ) {

        return System.getProperty( key );
        
    }
    
}
