/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $ID: PantherProxy.java,v 1.6 2001/06/12 20:58:43 burton Exp $
 * $Project: http://panther.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/panther/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * ---- 
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have received with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 * 
 */

package org.openprivacy.reptile.util;

import java.net.*;
import java.io.*;
import java.util.*;

import org.openprivacy.panther.components.*;

import talon.util.net.*;
import talon.components.*;
import talon.*;

/**
 * Contains resources necesary for reptile operation
 *
 * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
 * @version $Id: ReptileResources.java,v 1.38 2002/03/09 22:52:24 burton Exp $
 */
public class ReptileResources {

    public static final String REPTILE_SERVLET_PATH = "/reptile/servlet/reptile";

    public static final String REPTILE_HOME_LOCATION_KEY = "reptile.home.location";

    public static final String REPTILE_SEQUENCE_NAME_KEY = "reptile.sequence.name";

    public static final String REPTILE_CURRENT_LOCATION_KEY = "reptile.current.location";

    public static final String REPTILE_ACTION_KEY = "reptile.action";

    public static final String REPTILE_ACTION_NEXT_SEQUENCE_KEY = "reptile.action.next.sequence";

    public static final String REPTILE_ACTION_NEXT_LAYER_KEY = "reptile.action.next.layer";

    public static final String REPTILE_LAYER_KEY = "reptile.layer";

    public static final String TALON_LOG_DEBUG_KEY = "talon.log.debug";
    
    public static final String TALON_PROJECT = "sierra";

    public static final String PARSER = "org.apache.xerces.parsers.SAXParser";

    public static final String SEQUENCE_DISPATCH_NAMESPACE
        = "http://schemas.openprivacy.org/reptile/sequence-dispatch";

    public static final String CONTENT_TRANSFORMER_NAMESPACE
        = "http://schemas.openprivacy.org/reptile/content-transformer";

    public static final String CONTENT_LIST_NAMESPACE
        = "http://schemas.openprivacy.org/reptile/content-list";

    public static final String LAYOUT_NAMESPACE 
        = "http://schemas.openprivacy.org/reptile/layout";

    public static final String MARKS_NAMESPACE 
        = "http://schemas.openprivacy.org/reptile/marks";

    public static final String ERROR_NAMESPACE 
        = "http://schemas.openprivacy.org/reptile/error";

    public static final String CONTENT_FEEDS_NAMESPACE
        = "http://schemas.openprivacy.org/reptile/content-feeds";

    public static final String TASKS_NAMESPACE 
        = "http://schemas.openprivacy.org/reptile/settings/jvm/tasks";

    public static final String JAVA_PROPERTIES_NAMESPACE 
        = "http://schemas.openprivacy.org/reptile/java/properties";
    
    /**
     * If this URI is used then we should not use content detection but should
     * instead use the Stylesheet sequence mechanism.
     */
    public static String STYLESHEET_SEQUENCE_NAMESPACE
        = "http://schemas.openprivacy.org/reptile/stylesheet-sequence";

    public static String SYNDICATION_NAMESPACE
        = "http://purl.org/rss/1.0/modules/syndication/";

    public static String RDF_NAMESPACE
        = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";

    public static String DC_NAMESPACE
        = "http://purl.org/metadata/dublin_core#";

    public static String DC_OCLC_NAMESPACE
        = "http://purl.oclc.org/metadata/dublin_core#";
    
    public static String OCS_NAMESPACE_DIRECTORY
        = "http://alchemy.openjava.org/ocs/directory#";

    public static String OCS_NAMESPACE_SYNTAX
        = "http://alchemy.openjava.org/ocs/ocs-syntax#";

    public static final String SEARCH_NAMESPACE 
        = "http://schemas.openprivacy.org/reptile/search";

    public static final String RSS_1_0_NAMESPACE 
        = "http://purl.org/rss/1.0/";

    //public static final String REPTILE_STYLESHEET_ENGINE_ENABLED_KEY = 

    public static final String JAVAX_XML_TRANSFORM_TRANSFORMERFACTORY =
        "javax.xml.transform.TransformerFactory";

    public static final String DEFAULT_XML_ENCODING = "ISO-8859-1";

    public static final String XS_NAMESPACE = "http://www.w3.org/2001/XMLSchema-instance";

    //class variables
    private static ReptileResources instance = null;

    //instance variables
    private Proxy proxy = null;

    /**
     * Singleton getInstance
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton - burtonator</a>
     */
    public static ReptileResources getInstance() {

        if ( instance == null ) {

            instance = new ReptileResources();

        } 

        return instance;

    }

    /**
     * 
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: ReptileResources.java,v 1.38 2002/03/09 22:52:24 burton Exp $
     */
    public void setProxy( Proxy proxy ) {

        this.proxy = proxy;

    }

    /**
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: ReptileResources.java,v 1.38 2002/03/09 22:52:24 burton Exp $
     */
    public Proxy getProxy() {

        return this.proxy;

    }

}
