/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $ID: PantherProxy.java,v 1.6 2001/06/12 20:58:43 burton Exp $
 * $Project: http://panther.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/panther/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * ---- 
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have received with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 * 
 */

package org.openprivacy.reptile.util;

import java.net.*;
import java.io.*;
import java.util.*;

import org.openprivacy.panther.components.*;

import talon.util.net.*;
import talon.components.*;
import talon.*;

import org.jdom.*;

/**
 * Contains all Reptile XML namespaces.
 *
 * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
 * @version $Id: ReptileNamespaces.java,v 1.2 2002/02/26 09:17:57 burton Exp $
 */
public class ReptileNamespaces {

    public static final String RSS_NAMESPACE = "http://purl.org/rss/1.0/";
    
    public static final Namespace JDOM_RDF = Namespace.getNamespace( "rdf", ReptileResources.RDF_NAMESPACE );
    public static final Namespace JDOM_RSS = Namespace.getNamespace( "rss", RSS_NAMESPACE );
    
    public static final Namespace JDOM_SEARCH = Namespace.getNamespace( "search", ReptileResources.SEARCH_NAMESPACE );
    public static final Namespace JDOM_DC = Namespace.getNamespace( "dc", ReptileResources.DC_NAMESPACE );
    public static final Namespace JDOM_XS = Namespace.getNamespace( "xs", ReptileResources.XS_NAMESPACE );

}
