/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $ID: PantherProxy.java,v 1.6 2001/06/12 20:58:43 burton Exp $
 * $Project: http://panther.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/panther/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * ---- 
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have received with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 * 
 */

package org.openprivacy.reptile.util;

import java.io.*;
import java.net.*;
import java.util.*;

import org.openprivacy.panther.components.*;

import talon.*;
import talon.components.*;
import talon.util.*;
import talon.util.net.*;

import javax.servlet.*;
import javax.servlet.http.*;

import javax.xml.transform.*;

import org.apache.commons.collections.ExtendedProperties;

/**
 *
 * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
 * @version $Id: ParameterPasser.java,v 1.13 2002/02/04 22:47:33 burton Exp $
 */
public class ParameterPasser extends ExtendedProperties {

    public static final String[] REQUIRED_PARAMETERS = { "reptile.home.location", 
                                                         "reptile.sequence.name",
                                                         "reptile.current.location",
                                                         "reptile.current.sequence.name" };

    //instance vars
        
    //private ParameterAbstraction params = null;

    private HttpServletRequest request = null;

    private HttpServletResponse response  = null;   

    private String sequenceName = "";
    
    /**
     * 
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: ParameterPasser.java,v 1.13 2002/02/04 22:47:33 burton Exp $
     */
    public ParameterPasser() { }

    /**
     * 
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: ParameterPasser.java,v 1.13 2002/02/04 22:47:33 burton Exp $
     */
    public ParameterPasser( Transformer transformer ) {

        //try to get the main parameter passer given via HTTP so that we can set
        //params on this transformer.

        ParameterPasser real = (ParameterPasser)transformer.getParameter( ParameterPasser.class.getName() );

        Enumeration enum = real.keys();

        String name = null;
        Object value = null;
        
        while ( enum.hasMoreElements() ) {

            name = (String)enum.nextElement();

            value = real.get( name );

            Log.debug( "Passing param to Transformer: " + name, this );
            
            this.put( name, value );
            
        } 
        
    }

    /**
     * Create a ParameterPasser but use the sequence name passed over HTTP.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: ParameterPasser.java,v 1.13 2002/02/04 22:47:33 burton Exp $
     */
    public ParameterPasser( HttpServletRequest request,
                            HttpServletResponse response ) {

        this( request, response, request.getParameter( ReptileResources.REPTILE_SEQUENCE_NAME_KEY ) );

    }
    
    /**
     * 
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: ParameterPasser.java,v 1.13 2002/02/04 22:47:33 burton Exp $
     */
    public ParameterPasser( HttpServletRequest request,
                            HttpServletResponse response,
                            String sequenceName ) {

        if ( sequenceName == null )
            sequenceName = "urn:subscriptions";
        
        this.request = request;

        this.response = response;

        this.sequenceName = sequenceName;
        
        //this.params = new ParameterAbstraction( request );

        this.merge();
        
    }

    /**
     * Called when initialized from the ReptileServlet.  This is used to compute
     * the necessary "reptile.*" parameters.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: ParameterPasser.java,v 1.13 2002/02/04 22:47:33 burton Exp $
     */
    private void compute() {

        HttpSession session = request.getSession();

        this.put( "reptile.home.location", session.getAttribute( "reptile.home.location" ) );            

        String sessionID = request.getRequestedSessionId();

        StringBuffer reptileCurrentLocation = new StringBuffer();

        reptileCurrentLocation.append( this.get( "reptile.home.location" ) );
        
        reptileCurrentLocation.append( "?" + request.getQueryString() );
        
        this.put( "reptile.current.location", reptileCurrentLocation.toString() );

        this.put( "reptile.sequence.name", sequenceName );        

        //since this method is called only over HTTP, current sequence stays put
        //when passed into Xalan
        this.put( "reptile.current.sequence.name", sequenceName );
        
    }

    /**
     * Merge the properties from teh ParameterAbstraction into this Hashtable
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: ParameterPasser.java,v 1.13 2002/02/04 22:47:33 burton Exp $
     */
    public void merge() {
        
        Enumeration enum = request.getParameterNames();

        String name = null;
        String value = null;
        
        while ( enum.hasMoreElements() ) {

            name = (String)enum.nextElement();

            value = request.getParameter( name );

            this.put( name, value );
            
        } 

        //now compute the required params...
        this.compute();
    }

}

/**
 * If gets params from the passed object.
 *
 * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
 * @version $Id: ParameterPasser.java,v 1.13 2002/02/04 22:47:33 burton Exp $
 */
class ParameterAbstraction {

    HttpServletRequest request = null;

    private Hashtable params = new Hashtable();

    /**
     * 
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: ParameterPasser.java,v 1.13 2002/02/04 22:47:33 burton Exp $
     */
    public ParameterAbstraction( HttpServletRequest request ) {

        this.request = request;

    }
    
    /**
     * 
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: ParameterPasser.java,v 1.13 2002/02/04 22:47:33 burton Exp $
     */
    public String get( String name ) {

        if ( request != null ) {

            return (String)request.getParameter( name );
            
        } 

        return null;

    }

}
