/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $ID: PantherProxy.java,v 1.6 2001/06/12 20:58:43 burton Exp $
 * $Project: http://panther.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/panther/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * ---- 
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have received with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 * 
 */

package org.openprivacy.reptile.util;

import java.io.*;
import java.net.*;
import java.util.*;

import org.openprivacy.panther.components.*;

import talon.*;
import talon.components.*;
import talon.util.*;
import talon.util.net.*;

import javax.servlet.*;
import javax.servlet.http.*;

import javax.xml.transform.*;

import org.apache.commons.collections.ExtendedProperties;

/**
 *
 * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
 * @version $Id: PantherLink.java,v 1.4 2002/07/04 20:35:04 burton Exp $
 */
public class PantherLink {

    public static final String TYPE_LOCAL = "local";

    public static final String TYPE_SERVED = "served";

    public static final String ROOT = "/reptile/panther-cache";

    private static String type =
        SystemProperties.getString( SystemProperties.PANTHER_LINK_TYPE_KEY );

    /**
     * Get the link for a Panther link.  if we are serving them 'local' we
     * should use file:/ URLs, else use relative paths from the HTTP server.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public static String getLink( String file ) throws Exception {

        if ( TYPE_LOCAL.equals( type ) ) {

            //return a file URL
            return "file://" + file;
            
        } else if ( TYPE_SERVED.equals( type ) ) {

            String served = file.substring( file.indexOf( ROOT ), file.length() );
            
            //determine the path to this URL of /reptile/panther-cache/BLAH
            return served;

        } else {

            throw new Exception( "unknown type: " + type );

        }

    }
    
}
