/*
 * ---- 
 *
 * $Id: JUnitXPathTest.java,v 1.2 2002/02/03 04:24:22 burton Exp $
 * $Project: http://reptile.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/sierra/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 *
 * ----
 *
 * Copyright 2001 OpenPrivacy.org  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 */

package org.openprivacy.reptile.tests;

import java.io.*;
import java.net.*;
import java.util.*;

import org.openprivacy.reptile.actions.*;
import org.openprivacy.reptile.extensions.*;
import org.openprivacy.reptile.init.*;
import org.openprivacy.reptile.search.*;
import org.openprivacy.reptile.util.*;
import org.openprivacy.reptile.xml.*;
import org.openprivacy.reptile.xslt.*;

import talon.*;
import talon.components.*;
import talon.resources.*;
import talon.util.*;
import talon.util.net.*;

import junit.framework.*;

import org.jdom.*;

/**
 * 
 * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
 * @version $Id: JUnitXPathTest.java,v 1.2 2002/02/03 04:24:22 burton Exp $
 */
public class JUnitXPathTest  extends TestCase {

    /**
     * 
     * Create a new <code>JUnitXPathTest</code> instance.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public JUnitXPathTest( String name ) {

        super( name );
        
    }

    /**
     * Test single node operation..
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public void testSelectSingleNodeWithElement() throws Exception {

        ReptileXPath xpath = new ReptileXPath( "<hello>world</hello>", "/hello" );

        Element element = (Element)xpath.selectSingleNode();

        this.assert( element.getText().equals( "world" ) );
        
    }

    /**
     * Test single node operation..
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public void testSelectSingleNodeWithAttribute() throws Exception {

        ReptileXPath xpath = new ReptileXPath( "<hello foo=\"bar\"></hello>", "/hello/@foo" );

        Attribute attr = (Attribute)xpath.selectSingleNode();

        this.assert( attr.getValue().equals( "bar" ) );
        
    }

    /**
     * Test to make sure namespaces work.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public void testSelectSingleNodeWithNamespaces() throws Exception {

        ReptileXPath xpath = new ReptileXPath( "<hello:hello xmlns:hello=\"hello\" foo=\"bar\"></hello:hello>",
                                               "/hello:hello/@foo" );

        xpath.addNamespace( "hello", "hello" );
        
        Attribute attr = (Attribute)xpath.selectSingleNode();

        this.assert( attr.getValue().equals( "bar" ) );

    }

}

