/*
 * ---- 
 *
 * $Id: JUnitWellFormedTests.java,v 1.1 2003/02/03 13:11:20 burton Exp $
 * $Project: http://reptile.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/sierra/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 *
 * ----
 *
 * Copyright 2001 OpenPrivacy.org  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 */

package org.openprivacy.reptile.tests;

import java.io.*;
import java.net.*;
import java.util.*;

import org.openprivacy.reptile.*;
import org.openprivacy.reptile.actions.*;
import org.openprivacy.reptile.extensions.*;
import org.openprivacy.reptile.init.*;
import org.openprivacy.reptile.search.*;
import org.openprivacy.reptile.util.*;
import org.openprivacy.reptile.xml.*;
import org.openprivacy.reptile.xslt.*;

import talon.*;
import talon.components.*;
import talon.resources.*;
import talon.util.*;
import talon.util.net.*;

import junit.framework.*;

import org.jdom.*;

/**
 * 
 * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
 * @version $Id: JUnitWellFormedTests.java,v 1.1 2003/02/03 13:11:20 burton Exp $
 */
public class JUnitWellFormedTests  extends TestCase {

    /**
     * 
     * Create a new <code>JUnitWellFormedTests</code> instance.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public JUnitWellFormedTests( String name ) {

        super( name );
        
    }

    public void testWellFormedContentParser() throws Exception {

        assertEquals( "<b>Hello World</b>", WellFormedContentParser.parse( "<b>Hello World" ) );

        assertEquals( "<b>Hello World</b>", WellFormedContentParser.parse( "<b>Hello World</b>" ) );

        assertEquals( "<p><b>Hello World</b></p>", WellFormedContentParser.parse( "<p><b>Hello World" ) );

        //assertEquals( "<p>Hello World</p>", WellFormedContentParser.parse( "<p></b>Hello World" ) );

        assertEquals( "<p></p>", WellFormedContentParser.parse( "<p></b>" ) );

        //FIXME: this one is broken!
        //assertEquals( "<p><b>hello world</b></p>", WellFormedContentParser.parse( "<p><b>hello world</p></b>" ) );

        assertEquals( "<p><img src=\"helloworld.gif\"/></p>", WellFormedContentParser.parse( "<p><img src=\"helloworld.gif\">" ) );

        assertEquals( "<p><hr/></p>", WellFormedContentParser.parse( "<p><hr>" ) );

        //assertEquals( "<p>hello</p>", WellFormedContentParser.parse( "<p>he</broken>llo</p>" ) );

        assertEquals( "<b>\nHello World\n</b>", WellFormedContentParser.parse( "<b>\nHello World\n" ) );

        assertEquals( "<!-- <p>hello</p> -->", WellFormedContentParser.parse( "<!-- <p>hello</p> -->" ) );

        //what about a totally broken element like </asdf <hello> that would
        //totally break parsing...  maybe I should do a first pass to remove
        //totally broken Elements...
        
        // What about this? <p><b><i></b>asddf
        
    }

}

