/*
 * ---- 
 *
 * $Id: JUnitRelativizeTests.java,v 1.1 2003/02/03 13:11:20 burton Exp $
 * $Project: http://reptile.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/sierra/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 *
 * ----
 *
 * Copyright 2001 OpenPrivacy.org  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 */

package org.openprivacy.reptile.tests;

import java.io.*;
import java.net.*;
import java.util.*;

import org.openprivacy.reptile.*;
import org.openprivacy.reptile.actions.*;
import org.openprivacy.reptile.extensions.*;
import org.openprivacy.reptile.init.*;
import org.openprivacy.reptile.search.*;
import org.openprivacy.reptile.util.*;
import org.openprivacy.reptile.xml.*;
import org.openprivacy.reptile.xslt.*;

import talon.*;
import talon.components.*;
import talon.resources.*;
import talon.util.*;
import talon.util.net.*;

import junit.framework.*;

import org.jdom.*;

/**
 * 
 * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
 * @version $Id: JUnitRelativizeTests.java,v 1.1 2003/02/03 13:11:20 burton Exp $
 */
public class JUnitRelativizeTests  extends TestCase {

    /**
     * 
     * Create a new <code>JUnitRelativizeTests</code> instance.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public JUnitRelativizeTests( String name ) {

        super( name );
        
    }

    /**
     * Tests link expansion
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public void testRelativize() throws Exception {

        RelativizeContentParser test = new RelativizeContentParser();
        test.setResource( "http://www.cnn.com/foo/bar/" );

        assertEquals( "<a href=\"http://www.cnn.com/foo/bar/foo.html\">foo</a>",
                      test.relativize( "<a href=\"foo.html\">foo</a>" ) );

        assertEquals( "<img src=\"http://www.cnn.com/foo/bar/bar.jpg\"></a>",
                      test.relativize( "<img src=\"bar.jpg\"></a>" ) );

        assertEquals( "<img SRC=\"http://www.cnn.com/foo/bar/bar.jpg\" BORDER=\"0\"></a>",
                      test.relativize( "<img SRC=\"bar.jpg\" BORDER=\"0\"></a>" ) );

        assertEquals( "<a href=\"http://www.cnn.com/foo/bar/foo.html\"><img src=\"http://www.cnn.com/foo/bar/bar.jpg\"></a>",
                      test.relativize( "<a href=\"foo.html\"><img src=\"bar.jpg\"></a>" ) );

        assertEquals( "foo bar",
                      test.relativize( "foo bar" ) );

    }

    /**
     * Tests link expansion
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public void testExpand() throws Exception {

        //FIXME: how do I expand with directories that autoserve index.html and
        //the base site (http://www.foo.com
        
        RelativizeContentParser test = new RelativizeContentParser();

        //test off a file deep
        test.setResource( "http://www.cnn.com/foo/bar/index.html" );

        assertEquals( "http://www.cnn.com/foo/bar/foo.html", test.expand( "foo.html" ) );
        assertEquals( "http://www.cnn.com/foo/bar/index.html#name", test.expand( "#name" ) );
        assertEquals( "http://www.cnn.com/index.html", test.expand( "/index.html" ) );
        assertEquals( "http://www.cnn.com/foo/bar/cat/index.html", test.expand( "cat/index.html" ) );

        //test off the main site
        test = new RelativizeContentParser();        
        test.setResource( "http://www.cnn.com/" );

        assertEquals( "http://www.cnn.com/foo.html", test.expand( "foo.html" ) );
        assertEquals( "http://www.cnn.com/#name", test.expand( "#name" ) );
        assertEquals( "http://www.cnn.com/index.html", test.expand( "/index.html" ) );
        assertEquals( "http://www.cnn.com/cat/index.html", test.expand( "cat/index.html" ) );

        //test off a base file.
        test = new RelativizeContentParser();        
        test.setResource( "http://www.cnn.com/index.html" );
        assertEquals( "http://www.cnn.com/foo.html", test.expand( "foo.html" ) );
        assertEquals( "http://www.cnn.com/index.html#name", test.expand( "#name" ) );
        assertEquals( "http://www.cnn.com/index.html", test.expand( "/index.html" ) );
        assertEquals( "http://www.cnn.com/cat/index.html", test.expand( "cat/index.html" ) );

        //test off a deep file
        test = new RelativizeContentParser();        
        test.setResource( "http://www.cnn.com/foo/bar/" );
        assertEquals( "http://www.cnn.com/foo/bar/foo.html", test.expand( "foo.html" ) );
        assertEquals( "http://www.cnn.com/foo/bar/#name", test.expand( "#name" ) );
        assertEquals( "http://www.cnn.com/index.html", test.expand( "/index.html" ) );
        assertEquals( "http://www.cnn.com/foo/bar/cat/index.html", test.expand( "cat/index.html" ) );

        assertEquals( "http://www.cnn.com/foo/", test.expand( "../" ) );
        assertEquals( "http://www.cnn.com/foo/SRDF/index.html", test.expand( "../SRDF/index.html" ) );
        assertEquals( "http://www.cnn.com/foo/", test.expand( ".." ) );

        assertEquals( "http://www.cnn.com/", test.expand( "../.." ) );
        assertEquals( "http://www.cnn.com/", test.expand( "../../" ) );

        test = new RelativizeContentParser();        
        test.setResource( "http://www.theregister.co.uk/content/54/26810.html" );

        assertEquals( "http://www.theregister.co.uk", test.getSite() );
        
        assertEquals( "http://www.theregister.co.uk/images/reg_bullet.gif",
                      test.expand( "/images/reg_bullet.gif" ) );

        test = new RelativizeContentParser();        
        test.setResource( "http://www.politechbot.com" );
        assertEquals( "http://www.politechbot.com/p-03950.html",
                      test.expand( "p-03950.html" ) );

        test = new RelativizeContentParser();        
        test.setResource( "http://www.barebones.com/support/bbedit/bbedit-notes.html" );

        System.out.println( "barebones test" );
        
        assertEquals( "http://www.barebones.com/images/bbsw_banner/support.gif",
                      test.expand( "../../images/bbsw_banner/support.gif" ) );
        
        
    }

}
