/*
 * ---- 
 *
 * $Id: JUnitRSSParseTests.java,v 1.4 2002/08/26 05:50:29 burton Exp $
 * $Project: http://reptile.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/sierra/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 *
 * ----
 *
 * Copyright 2001 OpenPrivacy.org  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 */

package org.openprivacy.reptile.tests;

import java.io.*;
import java.net.*;
import java.util.*;

import org.openprivacy.reptile.*;
import org.openprivacy.reptile.actions.*;
import org.openprivacy.reptile.extensions.*;
import org.openprivacy.reptile.init.*;
import org.openprivacy.reptile.search.*;
import org.openprivacy.reptile.util.*;
import org.openprivacy.reptile.xml.*;
import org.openprivacy.reptile.xslt.*;

import talon.*;
import talon.components.*;
import talon.resources.*;
import talon.util.*;
import talon.util.net.*;

import junit.framework.*;

import org.jdom.*;

/**
 * 
 * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
 * @version $Id: JUnitRSSParseTests.java,v 1.4 2002/08/26 05:50:29 burton Exp $
 */
public class JUnitRSSParseTests  extends TestCase {

    /*

    http://saladwithsteve.com/#85368402

    http://saladwithsteve.com/#85373739

    http://scriptingnews.userland.com/backissues/2002/08/22#moreThoughtsOnLessig

    */
    
    /**
     * 
     * Create a new <code>JUnitRSSParseTests</code> instance.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public JUnitRSSParseTests( String name ) {

        super( name );
        
    }

    /**
     * Test single node operation..
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public void testCNN() throws Exception {

        testChannel( "http://www.cnn.com/2002/LAW/08/15/attacks.suit/index.html", 14 );

    }

    public void testSportsIllustrated() throws Exception {

        testChannel( "http://sportsillustrated.cnn.com/baseball/news/2002/08/16/strike_date_ap/", 30 );
        
    }

    public void testDayPop() throws Exception {

        testChannel( "http://www.daypop.com/redirect?id=34157577", 26 );
        
    }

    public void testFirstMonday() throws Exception {

        //fixme: ASSERT THAT WE HAVE A DESCRIPTION
        
        testChannel( "http://www.firstmonday.dk/issues/current_issue/", 10 );

    }

    public void testWashingtonPost() throws Exception {

        testChannel( "http://www.washingtonpost.com/ac2/wp-dyn/A14203-2002Jun19", 17 );

    }

    public void testMSNBC() throws Exception {

    }

    public void testFirstMondayArticle() throws Exception {

        testChannel( "http://www.firstmonday.dk/issues/current_issue/bowrey/index.html", 265 );

    }

    //http://rss.com.com/2100-1023-954591.html
    
    private RSSContentSerializer testChannel( String channel,
                                              int sections ) throws Exception {

        RSSContentSerializer test = new RSSContentSerializer();
        test.setResource( channel );
        test.parse();

        //assertTrue( test.getPCDATASections().length == sections  );

        return test;
        
    }
    
}

