/*
 * ---- 
 *
 * $Id: CactusTestSearch.java,v 1.9 2002/02/07 00:37:18 burton Exp $
 * $Project: http://reptile.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/sierra/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 *
 * ----
 *
 * Copyright 2001 OpenPrivacy.org  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 */

package org.openprivacy.reptile.tests;

import java.io.*;
import java.net.*;
import java.util.*;

import org.openprivacy.reptile.actions.*;
import org.openprivacy.reptile.extensions.*;
import org.openprivacy.reptile.init.*;
import org.openprivacy.reptile.search.*;
import org.openprivacy.reptile.search.impl.*;
import org.openprivacy.reptile.util.*;
import org.openprivacy.reptile.xml.*;
import org.openprivacy.reptile.xslt.*;

import talon.*;
import talon.components.*;
import talon.resources.*;
import talon.util.*;
import talon.util.net.*;

import junit.framework.*;
import org.apache.cactus.*;

import org.jdom.*;

/**
 * 
 * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
 * @version $Id: CactusTestSearch.java,v 1.9 2002/02/07 00:37:18 burton Exp $
 */
public class CactusTestSearch extends ServletTestCase {

    /**
     * 
     * Create a new <code>CactusTestSearch</code> instance.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public CactusTestSearch( String name ) {
        
        super( name );

    }

    /**
     * Test that a SearchRecord outputs XML correctly.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public void testSearchRecord() throws Exception {
        
        SearchRecord record = new SearchRecord();

        record.setTitle( "title" );
        record.setDescription( "description" );
        record.setLink( "link" );
        record.setIndex( 0 );

        Element elem = record.serialize();

        this.assertNotNull( elem );
        
    }

    /**
     * Test the SearchProviderManager.  Make sure it returns everything correctly.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public void testSearchProviderManager() throws Exception {

        //

        Class c_asp = ArticleSearchProvider.class;
        
        SearchProvider sp = SearchProviderManager.getInstance().newProvider( c_asp );

        //make sure we get back the right class.
        this.assertTrue( c_asp == sp.getClass() );
        
    }

    /**
     * the ArticleSearchProvider for Linux and assert that something was
     * returned.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public void testArticleSearchBasicCriteria() throws Exception {

        this.execSearch( "Linux", ArticleSearchProvider.class );
        
    }

    /**
     * 
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public void testSearchSerializerWithLinuxAsQuery() throws Exception {

        SearchProvider sp = this.execSearch( "Linux", ArticleSearchProvider.class );

        SearchSerializer serializer = new SearchSerializer( sp );

        String content;
        
        content = serializer.serializeAsString( 0 );

        //the first page should be from 0 -> 9
        ReptileXPath.assertXPath( content, "/search:search/search:results/@start", "0" );
        ReptileXPath.assertXPath( content, "/search:search/search:results/@end", "9" );

    }

    /**
     * Execute a search on the given provider and return it.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    private SearchProvider execSearch( String criteria, Class provider_class ) throws Exception {

        SearchProviderManager spm = SearchProviderManager.getInstance();

        SearchProvider sp = spm.newProvider( provider_class );

        SearchRequest request = new SearchRequest();

        //FIXME: this test needs to be fixed.  We should probably manually add
        //at least ONE record so that we know that a search should return at
        //least one.
        
        request.addCriteria( criteria );

        //search should never have been started.
        this.assertEquals( sp.getState(), SearchProvider.STATE_NEVER_SEARCHED );

        sp.search( request );

        //search should be complete on article providers AFTER a search is executed.
        this.assertEquals( sp.getState(), SearchProvider.STATE_SEARCH_COMPLETE );        

        //make sure we have at least ONE result.  Linux is a common term.
        this.assertTrue( sp.getResultCount() != 0 );

        //the SearchProviderManager should > 0 providers.
        this.assertTrue( spm.getSearchProviderCount() != 0 );
        
        return sp;
        
    }

    /**
     * 
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public void testSerializerPageNavigation() throws Exception {

        //FIXME: make sure that we return the correct page
        //FIXME: make sure that we don't have off by one errors in page navigation

        FakeSearchProvider fsp = new FakeSearchProvider();
        SearchSerializer serializer = new SearchSerializer( fsp );

        //test to see what happens on page 0 with no content.

        String content;

        content = serializer.serializeAsString( 0 );

        ReptileXPath.assertXPath( content, "/search:search/search:results/@start", "0" );
        ReptileXPath.assertXPath( content, "/search:search/search:results/@end", "0" );
        
        //make sure we have 0 pages, 0 
        
        //test to see what happens on page 1 with no content.
        try {

            serializer.serialize( 1 );

            //THIS SHOULD ALWAYS throw AN EXCEPTION

            throw new Exception( "This should have failed!" );
            
        } catch ( Exception e ) {

            System.out.println( "testSerializerPageNavigation: Exception caught successfully. " + e.getMessage() );
            
        }

        //ok... now add some basic records to the fsp, serialize it, and make
        //sure we get correct info.

        fsp.addRecord( new SearchRecord() );

        //we should only have one entry now...
        content = serializer.serializeAsString( 0 );

        ReptileXPath.assertXPath( content, "/search:search/search:results/@start", "0" );
        ReptileXPath.assertXPath( content, "/search:search/search:results/@end", "1" );

        //add exactly 10 items make sure I have 0 - 9 of 10
        fsp.addRecord( new SearchRecord() );
        fsp.addRecord( new SearchRecord() );
        fsp.addRecord( new SearchRecord() );
        fsp.addRecord( new SearchRecord() );
        fsp.addRecord( new SearchRecord() );
        fsp.addRecord( new SearchRecord() );
        fsp.addRecord( new SearchRecord() );
        fsp.addRecord( new SearchRecord() );
        fsp.addRecord( new SearchRecord() );

        content = serializer.serializeAsString( 0 );

        this.assertEquals( fsp.getResultCount(), 10 );
        
        ReptileXPath.assertXPath( content, "/search:search/search:results/@start", "0" );
        ReptileXPath.assertXPath( content, "/search:search/search:results/@end", "9" );
        ReptileXPath.assertXPath( content, "/search:search/search:results/@found", "10" );
        ReptileXPath.assertXPath( content, "/search:search/search:results/@page", "0" );
        ReptileXPath.assertXPath( content, "/search:search/search:results/@total-pages", "1" );

        //ok... if we add one more the total pages should be 2...

        fsp.addRecord( new SearchRecord() );

        //this.assertEquals( 13, fsp.getResultCount() );

        //the page count from the serializer should be 2 at this point.
        this.assertEquals( 2, serializer.getPageCount() );
        
        content = serializer.serializeAsString( 0 );

        ReptileXPath.assertXPath( content, "/search:search/search:results/@total-pages", "2" );

        //and if we request page 1 the start and end should be 10 and 11

        content = serializer.serializeAsString( 1 );

        ReptileXPath.assertXPath( content, "/search:search/search:results/@start", "10" );
        ReptileXPath.assertXPath( content, "/search:search/search:results/@end", "11" );

    }

}

/**
 * Used for serialization tests.  This way we can add fixed number of results
 * and then test serialization
 *
 * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
 */
class FakeSearchProvider extends AbstractSearchProvider {

    private Vector records = new Vector();

    /**
     * 
     * @see SearchProvider#search
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public void search( SearchRequest sr ) throws Exception {  }
    
    /**
     * @see SearchProvider#record
     * @throws Exception When an invalid SearchRecord index is used
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public void record( SearchRecord record ) throws Exception {

        //make sure we can use this.
        record.assertValid( this );
        
        int index = record.getIndex();

        //just get the given record directly...
        record = (SearchRecord)records.elementAt( index );

        record.setIndex( index );
        
    }

    /**
     * 
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public void addRecord( SearchRecord record ) {

        records.add( record );
        this.setResultCount( records.size() );
    }

    /**
     * 
     * @see SearchProvider#destroy
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public void destroy() {}

}
