/*
 * ---- 
 *
 * $Id: CactusTestContentTransformer.java,v 1.1 2002/02/08 01:14:59 burton Exp $
 * $Project: http://reptile.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/sierra/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 *
 * ----
 *
 * Copyright 2001 OpenPrivacy.org  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 */

package org.openprivacy.reptile.tests;

import java.io.*;
import java.net.*;
import java.util.*;

import org.openprivacy.reptile.actions.*;
import org.openprivacy.reptile.extensions.*;
import org.openprivacy.reptile.init.*;
import org.openprivacy.reptile.search.*;
import org.openprivacy.reptile.search.impl.*;
import org.openprivacy.reptile.util.*;
import org.openprivacy.reptile.xml.*;
import org.openprivacy.reptile.xslt.*;

import talon.*;
import talon.components.*;
import talon.resources.*;
import talon.util.*;
import talon.util.net.*;

import junit.framework.*;
import org.apache.cactus.*;

import org.jdom.*;

/**
 * <p> Test thats exercises the ContentTransformer.  A lot of RSS feed entries
 * are incorrect. These all have to deal with non-RSS 1.0 feeds.  Here we try to
 * lie to Reptile and say that a format is actually RSS 0.9x when it is really
 * RSS 0.9y.  Reptile needs to be smart enought to accept this and still render
 * RSS 1.0.
 *
 * <p> I need to make sure I test at least three RSS formats once.
 *
 <pre>

 test-rss-0.9.xml ->  http://my.netscape.com/rdf/simple/0.9/
        
 test-rss-0.91-dtd.xml -> http://my.netscape.com/publish/formats/rss-0.91.dtd

 http://my.netscape.com/publish/formats/rss-0.9.dtd

 </pre>

 * 
 * 
 * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
 * @version $Id: CactusTestContentTransformer.java,v 1.1 2002/02/08 01:14:59 burton Exp $
 */
public class CactusTestContentTransformer extends ServletTestCase {

    /**
     * 
     * Create a new <code>CactusTestContentTransformer</code> instance.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public CactusTestContentTransformer( String name ) {
        
        super( name );

    }

    /**
     * Test RSS .09 so that, even if we give it the wrong content-type, it still
     * works.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public void testRSS_0_9() throws Exception {

        testResource( "resource:/xml/tests/test-rss-0.9.xml" );

    }

    public void testRSS_0_9_1_dtd() throws Exception {

        testResource( "resource:/xml/tests/test-rss-0.91-dtd.xml" );
        testResource( "resource:/xml/tests/newscat.xml" );

    }

    /**
     * Test the given resource with the given formats.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    private void testResource( String resource ) throws Exception {

        //use the ContentTransformer to render the content.

        transformAndAssert( resource, "http://my.netscape.com/rdf/simple/0.9/" );
        
        transformAndAssert( resource, "http://my.netscape.com/publish/formats/rss-0.91.dtd" );

        transformAndAssert( resource, "http://my.netscape.com/publish/formats/rss-0.9.dtd" );

        // "http://www.scripting.com/dtd/rss-0.92.dtd"

    }
    
    /**
     * Transform the content from the given input, to the given content type and
     * assert that we have some valid RSS 1.0 data.  AKA at least SOME RSS 1.0
     * <entry>ies.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    private void transformAndAssert( String resource, String contentType ) throws Exception {

        ContentTransformer transformer = new ContentTransformer( new ParameterPasser() );

        String output = transformer.transform( resource, contentType, ReptileResources.RSS_1_0_NAMESPACE );

        ReptileXPath.assertXPathNodes( output, "/rdf:RDF/rss:item" );
        //ReptileXPath.assertXPathNotEqual( output, "/rdf:RDF/rss:item[0]/rss:title", "" );
        
    }
    
}
