/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $ID: PantherProxy.java,v 1.6 2001/06/12 20:58:43 burton Exp $
 * $Project: http://panther.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/panther/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * ---- 
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have received with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 * 
 */

package org.openprivacy.reptile.tasks;

import java.io.*;
import java.net.*;
import java.util.*;

import org.openprivacy.panther.components.*;

import org.openprivacy.reptile.util.*;

import talon.*;
import talon.components.*;
import talon.util.*;
import talon.util.net.*;

/**
 *
 * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
 * @version $Id: TaskInitializer.java,v 1.6 2002/03/23 22:31:35 burton Exp $
 */
public class TaskInitializer {

    public static final int MAX_TASK_THREADS =
        SystemProperties.getInteger( SystemProperties.REPTILE_TASKS_MAX_TASK_THREADS_KEY, 5 );

    public void init() {

        //don't create a new TaskThread if we are disabled.
        if ( TaskManager.checkTaskSystemDisabled() == false ) {

            for ( int i = 0; i < MAX_TASK_THREADS; ++i ) {

                new TaskThread().start();
                
            } 

        }

        //now run the SubscriptionProxyUpdateTask so that we can add RSS streams
        //to the tasks.

        TaskManager.runTask( new SubscriptionProxyUpdateTask() );
        
    }
    
}
