/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $ID: PantherProxy.java,v 1.6 2001/06/12 20:58:43 burton Exp $
 * $Project: http://panther.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/panther/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * ---- 
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have received with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 * 
 */

package org.openprivacy.reptile.tasks;

import java.net.*;
import java.io.*;
import java.util.*;

import org.openprivacy.panther.components.*;

import talon.util.net.*;
import talon.components.*;
import talon.*;

/**
 * Generic interface for running tasks in the background.  These are basically
 * just Threads.  
 *
 * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
 * @version $Id: Task.java,v 1.10 2002/03/23 22:31:35 burton Exp $
 */
public interface Task {

    /**
     * Specify a Task type of RSS
     */
    public static final String TYPE_RSS = "urn:task/type/rss";

    /**
     * Specify a Task type of OCS
     */
    public static final String TYPE_OCS = "urn:task/type/ocs";

    public static final String TYPE_UNKNOWN = "urn:task/type/unknown";

    public static final String MESSAGE_SUCCESSFUL = "Successful";

    public static final String STATE_STOPPED = "Stopped";

    public static final String STATE_PAUSED = "Paused";

    public static final String STATE_RUNNING = "Running";

    /**
     * Task was just run but it failed.
     */
    public static final String STATE_FAILED = "Failed";

    /**
     * Get an identifier for this Task.
     *
     * @version $Id: Task.java,v 1.10 2002/03/23 22:31:35 burton Exp $
     */
    public String getIdentifier();

    /**
     * @see #getIdentifier
     * @version $Id: Task.java,v 1.10 2002/03/23 22:31:35 burton Exp $
     */
    public void setIdentifier( String identifier );

    /**
     * Get the last time this task was ran.
     *
     * @version $Id: Task.java,v 1.10 2002/03/23 22:31:35 burton Exp $
     */
    public long getLastRan();

    /**
     * @version $Id: Task.java,v 1.10 2002/03/23 22:31:35 burton Exp $
     */
    public void setLastRan( long lastRan );

    /**
     * Get the interval that this task must run.  
     *
     * @version $Id: Task.java,v 1.10 2002/03/23 22:31:35 burton Exp $
     */
    public long getInterval();

    /**
     * @see #getInterval
     * @version $Id: Task.java,v 1.10 2002/03/23 22:31:35 burton Exp $
     */
    public void setInterval( long interval );

    /**
     * Get the last message generated for this task.
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     */
    public String getLastMessage();

    /**
     * @see #getLastMessage
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     */
    public void setLastMessage( String message );

    /**
     * @see #getLastMessage
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     */
    public void setLastMessage( Throwable t );

    /**
     * Set the state for this Task.
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     */
    public String getState();

    /**
     * @see setState
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     */
    public void setState( String state );

    /**
     * Return the type of this Task.
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     */
    public String getType();

    /**
     * Set the type of this Task.
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     */
    public void setType( String type );

    /**
     * Return true if this task is running.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public boolean isRunning();

    /**
     * Just like a runnable but we can throw an Exception.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public void run() throws Exception;
    
}
