/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $ID: PantherProxy.java,v 1.6 2001/06/12 20:58:43 burton Exp $
 * $Project: http://panther.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/panther/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * ---- 
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have received with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 * 
 */

package org.openprivacy.reptile.tasks;

import java.io.*;
import java.util.*;

import org.openprivacy.panther.components.*;

import talon.*;
import talon.components.*;
import talon.util.*;
import talon.util.net.*;

import org.openprivacy.reptile.util.*;
import org.openprivacy.reptile.xml.*;
import org.openprivacy.reptile.om.*;

/**
 * Responsible for updating Reptile subscriptions with the Proxy mechanism.
 *
 * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
 * @version $Id: SubscriptionProxyUpdateTask.java,v 1.15 2002/03/23 22:31:35 burton Exp $
 */
public class SubscriptionProxyUpdateTask extends BaseTask implements Task {
    
    /**
     * 
     * Create a new <code>SubscriptionProxyUpdateTask</code> instance.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     */
    public SubscriptionProxyUpdateTask() {

        this.setIdentifier( "urn:reptile/task/subscription-proxy-update" );
        
    }
    
    /**
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     */
    public void run() throws Exception {

        Channel[] subs = ChannelPeer.getSubscriptions();
            
        //tell the Proxy to update these URLs.

        Proxy proxy = ReptileResources.getInstance().getProxy();

        //now update them.

        String currentLocation = null;

        String currentContentType = null;
            
        for ( int i = 0; i < subs.length; ++ i ) {

            currentLocation = subs[ i ].getLocation();

            currentContentType = subs[ i ].getContentType();
                
            TaskManager tm = TaskManager.getInstance();
                
            if ( tm.contains( currentLocation ) == false ) {

                ProxyUpdateTask task = new ProxyUpdateTask( currentLocation, currentContentType );

                task.setType( Task.TYPE_RSS );

                //only register this task if 

                if ( tm.getTask( currentLocation ) == null ) {

                    //this task isn't registered... add it.
                    tm.register( task );
                        
                } 
                    
            } 
                
        } 
            
        setLastMessage( MESSAGE_SUCCESSFUL );

    }
    
}
