/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $ID: PantherProxy.java,v 1.6 2001/06/12 20:58:43 burton Exp $
 * $Project: http://panther.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/panther/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * ---- 
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have received with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 * 
 */

package org.openprivacy.reptile.tasks;

import java.io.*;
import java.net.*;
import java.util.*;

import org.openprivacy.panther.components.*;
import org.openprivacy.panther.event.*;

import talon.*;
import talon.components.*;
import talon.util.*;
import talon.util.net.*;

import org.openprivacy.reptile.util.*;
import org.openprivacy.reptile.xml.*;
import org.openprivacy.reptile.content.*;

/**
 * Responsible for updating content with the Proxy.
 *
 * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
 * @version $Id: ProxyUpdateTask.java,v 1.9 2002/03/23 22:31:35 burton Exp $
 */
public class ProxyUpdateTask extends BaseTask implements Task {
    
    /**
     * Holds the location this task is required to update.
     */
    private String location;

    private String contentType;

    private Proxy proxy = null;
    
    /**
     * 
     * Create a new <code>SubscriptionProxyUpdateTask</code> instance.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: ProxyUpdateTask.java,v 1.9 2002/03/23 22:31:35 burton Exp $
     */
    public ProxyUpdateTask( String location, String contentType ) {

        this.location = location;

        this.contentType = contentType;
        
        this.setIdentifier( location );
        
        this.proxy = ReptileResources.getInstance().getProxy();

    }
    
    /**
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     */
    public void run() throws Exception {

        if ( this.requireNotStale( location ) ) {
            return;
        } 
            
        //tell the Proxy to update this URL
        ProxyEntry entry = proxy.updateAndWait( location );
            
        String current = entry.getIdentifier().toString();
            
        //update the metainfo for this proxy entry if necessary.
        if ( current.equals( location ) ) {
                
            ContentMetaUpdate.update( location, contentType ); 
                                 
        } 

        setLastMessage( MESSAGE_SUCCESSFUL );
        
    }
    
}
