/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $ID: PantherProxy.java,v 1.6 2001/06/12 20:58:43 burton Exp $
 * $Project: http://panther.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/panther/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * ---- 
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have received with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 * 
 */

package org.openprivacy.reptile.tasks;

import java.io.*;
import java.net.*;
import java.util.*;

import org.openprivacy.panther.components.*;

import talon.*;
import talon.components.*;
import talon.util.*;
import talon.util.net.*;

import org.openprivacy.reptile.util.*;
import org.openprivacy.reptile.xml.*;

/**
 * Responsible for updating Reptile subscriptions with the Proxy mechanism.
 *
 * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
 * @version $Id: BaseTask.java,v 1.7 2002/03/09 22:52:24 burton Exp $
 */
public abstract class BaseTask implements Task {
    
    private String type = TYPE_UNKNOWN;
    
    private String state = STATE_STOPPED;
    
    private String lastMessage = "No message";

    private long interval = 5 * 60 * 1000; // 5 minutes...
        
    private long lastRan;
    
    private String identifier = null;

    /**
     * 
     * Get the value of <code>identifier</code>.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: BaseTask.java,v 1.7 2002/03/09 22:52:24 burton Exp $
     */
    public String getIdentifier() { 
        
        return this.identifier;
        
    }

    /**
     * 
     * Set the value of <code>identifier</code>.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: BaseTask.java,v 1.7 2002/03/09 22:52:24 burton Exp $
     */
    public void setIdentifier( String identifier ) {
        
        this.identifier = identifier;
        
    }

    /**
     * 
     * Get the value of <code>lastRan</code>.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: BaseTask.java,v 1.7 2002/03/09 22:52:24 burton Exp $
     */
    public long getLastRan() { 
        
        return this.lastRan;
        
    }

    /**
     * 
     * Set the value of <code>lastRan</code>.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: BaseTask.java,v 1.7 2002/03/09 22:52:24 burton Exp $
     */
    public void setLastRan( long lastRan ) { 
        
        this.lastRan = lastRan;
        
    }

    /**
     * 
     * Get the value of <code>interval</code>.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: BaseTask.java,v 1.7 2002/03/09 22:52:24 burton Exp $
     */
    public long getInterval() { 
        
        return this.interval;
        
    }

    /**
     * 
     * Set the value of <code>interval</code>.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: BaseTask.java,v 1.7 2002/03/09 22:52:24 burton Exp $
     */
    public void setInterval( long interval ) { 
        
        this.interval = interval;
        
    }

    /**
     * 
     * Set the value of <code>lastMessage</code>.
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     */
    public void setLastMessage( String lastMessage ) { 
        
        this.lastMessage = lastMessage;
        
    }

    /**
     * 
     * Set the value of <code>lastMessage</code>.
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     */
    public void setLastMessage( Throwable t ) { 
        
        setLastMessage( t.getMessage() );
        
    }

    /**
     * 
     * Get the value of <code>lastMessage</code>.
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     */
    public String getLastMessage() { 
        
        return this.lastMessage;
        
    }
    
    /**
     * 
     * Get the value of <code>state</code>.
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     */
    public String getState() { 
        
        return this.state;
        
    }

    /**
     * 
     * Set the value of <code>state</code>.
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     */
    public void setState( String state ) { 
        
        this.state = state;
        
    }

    /**
     * 
     * Set the value of <code>type</code>.
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     */
    public void setType( String type ) { 
        
        this.type = type;
        
    }

    /**
     * 
     * Get the value of <code>type</code>.
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     */
    public String getType() { 
        
        return this.type;
        
    }

    /**
     * @see Task#isRunning
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public boolean isRunning() {

        return this.getState().equals( STATE_RUNNING );
        
    }

    /**
     * When compared to the current threads interval... and current time.  Retrn
     * true if this proxy entry is stale.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    protected boolean stale( ProxyEntry entry ) {

        return System.currentTimeMillis() - entry.getLastModified() > getInterval();
        
    }

    /**
     * Perform a test to make sure the content is not stale, if it is (and
     * testing for this is enabled), we return true.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    protected boolean requireNotStale( String location ) {

        try { 
            
            Proxy proxy = ReptileResources.getInstance().getProxy();
            
            if ( proxy.contains( location ) ) {
                
                ProxyEntry entry = proxy.get( location );
                
                if ( this.stale( entry ) == false ) {
                    String message = "Content is not stale: " + location;
                    this.setLastMessage( message );
                    Log.message( message );
                    return true;
                } 
                
            } 
            
        } catch ( Throwable t ) {
            
            t.printStackTrace();
            
        }

        return false;
        
    }
    
}

