/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $ID: PantherProxy.java,v 1.6 2001/06/12 20:58:43 burton Exp $
 * $Project: http://panther.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/panther/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * ---- 
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have received with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 * 
 */

package org.openprivacy.reptile.search.tasks;

import java.io.*;
import java.net.*;
import java.util.*;

import org.openprivacy.reptile.content.*;
import org.openprivacy.reptile.search.*;
import org.openprivacy.reptile.tasks.*;
import org.openprivacy.reptile.util.*;
import org.openprivacy.reptile.xml.*;

/**
 * Handles garbage collecting all SearchProviders.
 * 
 * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
 * @version $Id: SearchGCTask.java,v 1.2 2001/12/30 01:54:54 burton Exp $
 */
public class SearchGCTask extends BaseTask implements Task {

    /**
     * The maximum amount of time that a provider should around for.  By default
     * this is 300000 milliseconds or 5 minutes.
     */
    public static final long PROVIDER_MAX_GC_TIME = 5 * 60 * 1000;
    
    /**
     * 
     * Create a new <code>SearchGCTask</code> instance.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: SearchGCTask.java,v 1.2 2001/12/30 01:54:54 burton Exp $
     */
    public SearchGCTask() {}

    /**
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     */
    public void run() {
        
        //Look at the SearchProviderManager, if any SearchProviders have been
        //around too long we need to GC them.

        SearchProviderManager spm = SearchProviderManager.getInstance();        

        Iterator iterator = spm.getSearchProviders();

        while ( iterator.hasNext() ) {

            SearchProvider provider = (SearchProvider)iterator.next();

            //determine how long the search provider has been around for.

            long lifetime = System.currentTimeMillis() - provider.getTimeCreated();
            
            if ( lifetime > PROVIDER_MAX_GC_TIME ) {

                //ok.  This provider is too old.  GC it.

                spm.destroy( provider );
                
            } 

        } 

    }
    
}
