/*
 * ---- 
 *
 * $Id: RecentArticlesSearchRequest.java,v 1.2 2002/02/09 07:31:21 burton Exp $
 * $Project: http://reptile.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/sierra/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 *
 * ----
 *
 * Copyright 2001 OpenPrivacy.org  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 */

package org.openprivacy.reptile.search.requests;

import java.io.*;
import java.net.*;
import java.util.*;

import org.openprivacy.reptile.actions.*;
import org.openprivacy.reptile.extensions.*;
import org.openprivacy.reptile.init.*;
import org.openprivacy.reptile.search.*;
import org.openprivacy.reptile.search.impl.*;
import org.openprivacy.reptile.om.*;
import org.openprivacy.reptile.util.*;
import org.openprivacy.reptile.xslt.*;

import org.apache.commons.collections.*;

import org.jdom.*;
import org.jdom.output.*;

/**
 * <p> Finds the most recent (last 1000 or so) articles found within the system.
 * 
 * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
 * @version $Id: RecentArticlesSearchRequest.java,v 1.2 2002/02/09 07:31:21 burton Exp $
 */
public class RecentArticlesSearchRequest extends AdvancedSearchRequest {

    public static final int MAX_COUNT = 1000;
    
    /**
     * 
     * Create a new <code>RecentArticlesSearchRequest</code> instance.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public RecentArticlesSearchRequest() {

        //compute the time... should be about an hour ago.

        this.getSearchFields().add( ArticlePeer.TITLE );

        this.setComparator( SearchRequest.NOT_EQUAL );

        this.getCriteria().add( "" );
        
        this.setMaxCount( MAX_COUNT );
        
        this.setRequiredSearchProvider( ArticleSearchProvider.class );

    }

}
