/*
 * ---- 
 *
 * $Id: RSSWeblogSearchRequest.java,v 1.1 2002/02/24 22:46:02 burton Exp $
 * $Project: http://reptile.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/sierra/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 *
 * ----
 *
 * Copyright 2001 OpenPrivacy.org  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 */

package org.openprivacy.reptile.search.requests;

import java.io.*;
import java.net.*;
import java.util.*;

import org.openprivacy.reptile.actions.*;
import org.openprivacy.reptile.extensions.*;
import org.openprivacy.reptile.init.*;
import org.openprivacy.reptile.search.*;
import org.openprivacy.reptile.search.impl.*;
import org.openprivacy.reptile.om.*;
import org.openprivacy.reptile.util.*;
import org.openprivacy.reptile.xslt.*;

import org.apache.commons.collections.*;

import org.jdom.*;
import org.jdom.output.*;

import talon.*;
import talon.util.*;

/**
 * <p> Provide a SearchResult that can be used to stream out RSS.
 * 
 * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
 * @version $Id: RSSWeblogSearchRequest.java,v 1.1 2002/02/24 22:46:02 burton Exp $
 */
public class RSSWeblogSearchRequest extends AdvancedSearchRequest {

    /**
     * 
     * Create a new <code>RSSWeblogSearchRequest</code> instance.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public RSSWeblogSearchRequest() {

        this.getSearchFields().add( WeblogPeer.TITLE );

        //use the correct setting.

        //FIXME: should we use a setting for this?
    
        this.setMaxCount( 10 );
        
        //like anything...
        this.addCriteria( "" );
        this.setComparator( SearchRequest.LIKE );

        // sort by title.

        this.getSortOrder().add(  WeblogPeer.TITLE );

        this.setRequiredSearchProvider( WeblogSearchProvider.class );

    }

}
