/*
 * ---- 
 *
 * $Id: RSSChannelSearchRequest.java,v 1.3 2002/02/26 10:39:57 burton Exp $
 * $Project: http://reptile.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/sierra/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 *
 * ----
 *
 * Copyright 2001 OpenPrivacy.org  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 */

package org.openprivacy.reptile.search.requests;

import java.io.*;
import java.net.*;
import java.util.*;

import org.openprivacy.reptile.actions.*;
import org.openprivacy.reptile.extensions.*;
import org.openprivacy.reptile.init.*;
import org.openprivacy.reptile.search.*;
import org.openprivacy.reptile.search.impl.*;
import org.openprivacy.reptile.om.*;
import org.openprivacy.reptile.util.*;
import org.openprivacy.reptile.xslt.*;

import org.apache.commons.collections.*;

import org.jdom.*;
import org.jdom.output.*;

import talon.*;
import talon.util.*;

/**
 * <p> Provide a SearchResult that can be used to stream out RSS.
 * 
 * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
 * @version $Id: RSSChannelSearchRequest.java,v 1.3 2002/02/26 10:39:57 burton Exp $
 */
public class RSSChannelSearchRequest extends AdvancedSearchRequest {

    /**
     * 
     * Create a new <code>RSSChannelSearchRequest</code> instance.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public RSSChannelSearchRequest( String channel ) throws Exception {

        this.getSearchFields().add( ArticlePeer.CHANNEL );

        //use the correct setting.

        int max = Integer.parseInt( SettingPeer.getSetting( "reptile.setting.rss.channel.size" ).getValue() );
        
        this.setMaxCount( max );
        
        //like anything...
        this.addCriteria( channel );
        this.setComparator( SearchRequest.EQUAL );

        // sort by title.

        this.getSortOrder().add(  ArticlePeer.DATE_FOUND );

        this.setRequiredSearchProvider( ArticleSearchProvider.class );

    }

}
