/*
 * ---- 
 *
 * $Id: AdvancedSearchRequest.java,v 1.1 2002/02/09 07:33:05 burton Exp $
 * $Project: http://reptile.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/sierra/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 *
 * ----
 *
 * Copyright 2001 OpenPrivacy.org  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 */

package org.openprivacy.reptile.search.requests;

import java.io.*;
import java.net.*;
import java.util.*;

import org.openprivacy.reptile.actions.*;
import org.openprivacy.reptile.extensions.*;
import org.openprivacy.reptile.init.*;
import org.openprivacy.reptile.search.*;
import org.openprivacy.reptile.om.*;
import org.openprivacy.reptile.util.*;
import org.openprivacy.reptile.xslt.*;

import org.apache.commons.collections.*;

import org.jdom.*;
import org.jdom.output.*;

import talon.*;
import talon.util.*;

/**
 * Contains additional information that a SearchProvider requires.
 * 
 * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
 * @version $Id: AdvancedSearchRequest.java,v 1.1 2002/02/09 07:33:05 burton Exp $
 */
public class AdvancedSearchRequest extends SearchRequest {
    
    private Class requiredSearchProvider = null;

    /**
     * 
     * Set the value of <code>requiredSearchProvider</code>.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public void setRequiredSearchProvider( Class requiredSearchProvider ) { 
        
        this.requiredSearchProvider = requiredSearchProvider;
        
    }

    /**
     * 
     * Specify the SearchProvider that this AdvancedSearchRequest supports.
     * This is used to restrict this SearchRequest to a specific SearchProvider.
     * for example if your SearchRequest only works with JXTA you can restict
     * this to a JXTA provider.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public Class getRequiredSearchProvider() { 
        
        return this.requiredSearchProvider;
        
    }

}
