/*
 * ---- 
 *
 * $Id: TaskLogSearchProvider.java,v 1.1 2002/07/06 05:59:32 burton Exp $
 * $Project: http://reptile.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/sierra/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 *
 * ----
 *
 * Copyright 2001 OpenPrivacy.org  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 */

package org.openprivacy.reptile.search.impl;

import java.io.*;
import java.net.*;
import java.util.*;

import org.openprivacy.reptile.actions.*;
import org.openprivacy.reptile.extensions.*;
import org.openprivacy.reptile.init.*;
import org.openprivacy.reptile.om.*;
import org.openprivacy.reptile.search.*;
import org.openprivacy.reptile.util.*;
import org.openprivacy.reptile.xslt.*;

// Village classes
import com.workingdogs.village.*;

// Turbine classes
import org.apache.turbine.om.peer.*;
import org.apache.turbine.util.*;
import org.apache.turbine.util.db.*;
import org.apache.turbine.util.db.map.*;
import org.apache.turbine.util.db.pool.DBConnection;

// Local classes
import org.openprivacy.reptile.om.map.*;

/**
 * Handles searching articles in the OM database article store.
 * 
 * @see SearchProvider
 * @see AbstractSearchProvider
 * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
 * @version $Id: TaskLogSearchProvider.java,v 1.1 2002/07/06 05:59:32 burton Exp $
 */
public class TaskLogSearchProvider extends DBSearchProvider {

    /**
     * 
     * Create a new <code>TaskLogSearchProvider</code> instance.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public TaskLogSearchProvider() {
        
        super( TaskLogPeer.class );

        super.defaultSearchFields.add( TaskLogPeer.IDENTIFIER );
        super.defaultSearchFields.add( TaskLogPeer.MESSAGE );

        super.defaultSortOrder.add( TaskLogPeer.DATE );
        
    }
    

    /**
     * @see SearchProvider#record
     * @throws Exception When an invalid SearchRecord index is used
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public void record( SearchRecord record ) throws Exception {

        record.assertValid( this );
        
        int index = record.getIndex();

        TaskLog current = (TaskLog)getResults().elementAt( index );

        record.setTitle( current.getExceptionClassname() );
        record.setDateFound( current.getDate() );
        record.setDescription( current.getMessage() );
        record.setLink( current.getIdentifier() );
        
        record.setChannel( current.getIdentifier() );
        
    }

    /**
     * 
     * @see SearchProvider#destroy
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public void destroy() {}
    
}
