/*
 * ---- 
 *
 * $Id: PeerSearchProvider.java,v 1.1 2002/03/18 09:26:38 burton Exp $
 * $Project: http://reptile.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/sierra/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 *
 * ----
 *
 * Copyright 2001 OpenPrivacy.org  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 */

package org.openprivacy.reptile.search.impl;

import java.io.*;
import java.net.*;
import java.util.*;

import org.openprivacy.reptile.actions.*;
import org.openprivacy.reptile.init.*;
import org.openprivacy.reptile.om.*;
import org.openprivacy.reptile.search.*;
import org.openprivacy.reptile.util.*;
import org.openprivacy.reptile.xslt.*;

// Village classes
import com.workingdogs.village.*;

// Turbine classes
import org.apache.turbine.om.peer.*;
import org.apache.turbine.util.*;
import org.apache.turbine.util.db.*;
import org.apache.turbine.util.db.map.*;
import org.apache.turbine.util.db.pool.DBConnection;

// Local classes
import org.openprivacy.reptile.om.map.*;

/**
 * Handles searching articles in the OM database article store.
 * 
 * @see SearchProvider
 * @see AbstractSearchProvider
 * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
 * @version $Id: PeerSearchProvider.java,v 1.1 2002/03/18 09:26:38 burton Exp $
 */
public class PeerSearchProvider extends DBSearchProvider {

    /**
     * 
     * Create a new <code>PeerSearchProvider</code> instance.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public PeerSearchProvider() {
        
        super( PeerAdvertisementPeer.class );

        super.defaultSearchFields.add( PeerAdvertisementPeer.NAME );
        super.defaultSearchFields.add( PeerAdvertisementPeer.TITLE );
        super.defaultSearchFields.add( PeerAdvertisementPeer.DESCRIPTION );

        super.defaultSortOrder.add( PeerAdvertisementPeer.DATE_FOUND );
        
    }

    /**
     * @see SearchProvider#record
     * @throws Exception When an invalid SearchRecord index is used
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public void record( SearchRecord record ) throws Exception {

        record.assertValid( this );
        
        int index = record.getIndex();

        PeerAdvertisement entry = (PeerAdvertisement)getResults().elementAt( index );

        record.setTitle( entry.getTitle() );
        record.setDateFound( entry.getDateFound() );
        record.setDescription( entry.getDescription() );
        record.setLink( entry.getPeerID() );

        //TODO: what do we do about this?  We need some type of channel
        //identification for the Peer.
        //record.setChannel( entry.getChannel() );
        
    }

    /**
     * 
     * @see SearchProvider#destroy
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public void destroy() {}
    
}
