/*
 * ---- 
 *
 * $Id: SearchRecord.java,v 1.12 2002/02/06 01:06:03 burton Exp $
 * $Project: http://reptile.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/sierra/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 *
 * ----
 *
 * Copyright 2001 OpenPrivacy.org  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 */

package org.openprivacy.reptile.search;

import java.io.*;
import java.net.*;
import java.util.*;

import org.openprivacy.reptile.actions.*;
import org.openprivacy.reptile.extensions.*;
import org.openprivacy.reptile.init.*;
import org.openprivacy.reptile.util.*;
import org.openprivacy.reptile.xslt.*;

import talon.*;
import talon.components.*;
import talon.resources.*;
import talon.util.*;
import talon.util.net.*;

import org.jdom.*;
import org.jdom.output.*;

/**
 *
 * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
 * @version $Id: SearchRecord.java,v 1.12 2002/02/06 01:06:03 burton Exp $
 */
public class SearchRecord {
    
    private String channel = null;

    public static final int NO_INDEX = -1;

    private long dateFound;
    
    private String description = "";
    
    private String title = "";
    
    private String link = "";
    
    private int index = NO_INDEX;

    /**
     * 
     * Set the value of <code>index</code>.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public void setIndex( int index ) { 
        
        this.index = index;
        
    }

    /**
     * 
     * <p>Get the value of <code>index</code>.
     *
     * <p>Note that all indexes begin at 0
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public int getIndex() { 
        
        return this.index;
        
    }

    /**
     * 
     * Get the value of <code>link</code>.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public String getLink() { 
        
        return this.link;
        
    }

    /**
     * 
     * Set the value of <code>link</code>.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public void setLink( String link ) { 
        
        this.link = link;
        
    }

    /**
     * 
     * Get the value of <code>description</code>.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public String getDescription() { 
        
        return this.description;
        
    }

    /**
     * 
     * Set the value of <code>description</code>.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public void setDescription( String description ) { 
        
        this.description = description;
        
    }

    /**
     * 
     * Get the value of <code>title</code>.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public String getTitle() { 
        
        return this.title;
        
    }

    /**
     * 
     * Set the value of <code>title</code>.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public void setTitle( String title ) { 
        
        this.title = title;
        
    }

    /**
     * 
     * Set the value of <code>dateFound</code>.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public void setDateFound( long dateFound ) { 
        
        this.dateFound = dateFound;
        
    }

    /**
     * 
     * Get the value of <code>dateFound</code>.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public long getDateFound() { 
        
        return this.dateFound;
        
    }

    /**
     * 
     * Get the value of <code>channel</code>.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public String getChannel() { 
        
        return this.channel;
        
    }

    /**
     * 
     * Set the value of <code>channel</code>.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public void setChannel( String channel ) { 
        
        this.channel = channel;
        
    }

    /**
     * Serialize this is a JDOM element.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public Element serialize() {

        Element entry = new Element( "entry", ReptileNamespaces.JDOM_SEARCH );

        entry.addContent( new Element( "title", ReptileNamespaces.JDOM_DC ).setText( getTitle() ) );
        entry.addContent( new Element( "description", ReptileNamespaces.JDOM_DC ).setText( getDescription() ) );

        Element link = new Element( "link", ReptileNamespaces.JDOM_SEARCH );

        link.setAttribute( "date-found", Long.toString( this.getDateFound() ) );
        
        link.setAttribute( "location", this.getLink() );

        if ( this.getChannel() != null )
            link.setAttribute( "channel", this.getChannel() );

        entry.addContent( link );

        return entry;

    }

    /**
     * Make sure we can use this.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public void assertValid( SearchProvider provider ) throws Exception {

        if ( index == SearchRecord.NO_INDEX )
            throw new Exception( "Index for records not specified.  Must be > 0. " + index );

        if ( index > provider.getResultCount() )
            throw new Exception( "Index out of range - " + index );

    }

}
