/*
 * ---- 
 *
 * $Id: RemoteSearchProvider.java,v 1.1 2002/02/23 10:44:26 burton Exp $
 * $Project: http://reptile.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/sierra/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 *
 * ----
 *
 * Copyright 2001 OpenPrivacy.org  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 */

package org.openprivacy.reptile.search;

import java.io.*;
import java.net.*;
import java.util.*;

import org.openprivacy.reptile.actions.*;
import org.openprivacy.reptile.extensions.*;
import org.openprivacy.reptile.init.*;
import org.openprivacy.reptile.util.*;
import org.openprivacy.reptile.xslt.*;

/**
 * <p> A RemoteSearchProvider is responsible for executing a search on a remote
 * network.  This is probably a P2P network but could also support RPC style
 * activities (XMLRPC/SOAP).
 * 
 * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
 * @version $Id: RemoteSearchProvider.java,v 1.1 2002/02/23 10:44:26 burton Exp $
 */
public interface RemoteSearchProvider extends SearchProvider {


    /**
     * Add a found SearchResult to this RemoteSearchProvider.  This is used to
     * aggregate results so that they can be returned.  When a
     * RemoteSearchProvider receives a result it should call addSearchResult so
     * that it is included in the local result set.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public void addSearchRecord( SearchRecord record );


    /**
     * <p> Identical to the record() method interface in SearchProvider.  The
     * difference here is that record() may not be able to return right away and
     * might have to pull the record from a remote peer/host if necessary.
     * 
     * <p> Ideally Reptile would keep a record in a local cache so that it can
     * return it right away but this might not always be possible.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public void record() throws Exception;
    
}
