/*
 * ---- 
 *
 * $Id: AbstractSearchProvider.java,v 1.9 2002/02/07 11:08:13 burton Exp $
 * $Project: http://reptile.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/sierra/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 *
 * ----
 *
 * Copyright 2001 OpenPrivacy.org  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 */

package org.openprivacy.reptile.search;

import java.io.*;
import java.net.*;
import java.util.*;

import org.openprivacy.reptile.actions.*;
import org.openprivacy.reptile.extensions.*;
import org.openprivacy.reptile.init.*;
import org.openprivacy.reptile.util.*;
import org.openprivacy.reptile.xslt.*;

import talon.*;
import talon.components.*;
import talon.resources.*;
import talon.util.*;
import talon.util.net.*;

/**
 * Abstract implementation of a SearchProvider, all SearchProviders should
 * implement this interface.
 * 
 * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
 * @version $Id: AbstractSearchProvider.java,v 1.9 2002/02/07 11:08:13 burton Exp $
 */
public abstract class AbstractSearchProvider implements SearchProvider {
    
    private long searchCompletedTime;
    
    private long searchStartTime;
    
    private SearchRequest searchRequest = null;
    
    private int state = SearchProvider.STATE_NEVER_SEARCHED;
    
    private int resultCount = 0;

    private long timeCreated = System.currentTimeMillis();
    
    private String handle = Long.toString( timeCreated );
    
    /**
     * 
     * Get the value of <code>resultCount</code>.
     *
     * @see SearchProvider
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public final int getResultCount() { 
        
        return this.resultCount;
        
    }

    /**
     * 
     * Set the value of <code>resultCount</code>.
     *
     * @see SearchProvider
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public final void setResultCount( int resultCount ) { 
        
        this.resultCount = resultCount;
        
    }

    /**
     * @see SearchProvider
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public final String getHandle() {

        return handle;
        
    }

    /**
     * @see SearchProvider
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public final long getTimeCreated() {
        return timeCreated;
    }

    /**
     * 
     * Get the value of <code>state</code>.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public final int getState() { 
        
        return this.state;
        
    }

    /**
     *
     * @see SearchProvider#getState
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public final String getState( int state ) {

        switch ( state ) {

            case SearchProvider.STATE_NEVER_SEARCHED:
                return "never-searched";

            case SearchProvider.STATE_SEARCH_COMPLETE:
                return "search-complete";

            case SearchProvider.STATE_SEARCH_IN_PROGRESS:
                return "search-in-progress";

            default:
                return "unknown";

        } // end of switch ()

    }

    /**
     * 
     * Set the value of <code>state</code>.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public final void setState( int state ) { 

        switch ( state ) {

            case SearchProvider.STATE_SEARCH_IN_PROGRESS: 
                this.setSearchStartTime( System.currentTimeMillis() );                
                break;
 
            case SearchProvider.STATE_SEARCH_COMPLETE: 
                this.setSearchCompletedTime( System.currentTimeMillis() );                
                break;

        }

        this.state = state;
        
    }

    /**
     * @see SearchProvider#isSearchable
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public final boolean isSearchable() {

        return this.getState() == STATE_NEVER_SEARCHED;
        
    }

    /**
     * @see SearchProvider#isSearchable
     * @see SearchProvider#assertSearchable
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public final void assertSearchable() throws Exception {

        if ( this.isSearchable() == false ) 
            throw new Exception( "This provider is not searchable." );

    }

    /**
     * 
     * Get the value of <code>searchRequest</code>.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public SearchRequest getSearchRequest() { 
        
        return this.searchRequest;
        
    }

    /**
     * 
     * Set the value of <code>searchRequest</code>.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public void setSearchRequest( SearchRequest searchRequest ) { 
        
        this.searchRequest = searchRequest;
        
    }

    /**
     * 
     * Get the value of <code>searchStartTime</code>.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public long getSearchStartTime() { 
        
        return this.searchStartTime;
        
    }

    /**
     * 
     * Set the value of <code>searchStartTime</code>.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public void setSearchStartTime( long searchStartTime ) { 
        
        this.searchStartTime = searchStartTime;
        
    }

    /**
     * 
     * Get the value of <code>searchCompletedTime</code>.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public long getSearchCompletedTime() { 
        
        return this.searchCompletedTime;
        
    }

    /**
     * 
     * Set the value of <code>searchCompletedTime</code>.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public void setSearchCompletedTime( long searchCompletedTime ) { 
        
        this.searchCompletedTime = searchCompletedTime;
        
    }

}
