package org.openprivacy.reptile.om;

// JDK classes
import java.util.*;
import java.io.*;

// Village classes
import com.workingdogs.village.*;

// Turbine classes
import org.apache.turbine.om.peer.*;
import org.apache.turbine.util.*;
import org.apache.turbine.util.db.*;
import org.apache.turbine.util.db.map.*;
import org.apache.turbine.util.db.pool.DBConnection;

// Local classes
import org.openprivacy.reptile.om.map.*;
import org.openprivacy.reptile.tasks.*;


/** 
  * The skeleton for this class was autogenerated by Torque on:
  *
  * [Sat Mar 23 13:48:31 PST 2002]
  *
  *  You should add additional methods to this class to meet the
  *  application requirements.  This class will only be generated as
  *  long as it does not already exist in the output directory.
  */
public class TaskLogPeer 
    extends org.openprivacy.reptile.om.BaseTaskLogPeer
{

    public static final String STATUS_FAILED = "failed";

    public static final String STATUS_SUCCESS = "success";

    /**
     * 
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public static final void success( Task task ) {

        success( task, null );
        
    }

    /**
     * 
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public static final void success( Task task,
                                      String message ) {

        try { 
            
            
            TaskLog log = new TaskLog();
            log.setIdentifier( task.getIdentifier() );
            log.setStatus( STATUS_SUCCESS );
            log.setTask( task.getClass().getName() );
            
            if ( message != null ) {
                
                log.setMessage( message );
                
            } 
            
            log.save();
            
        } catch ( Throwable t ) { }
        
    }
    
    /**
     * Add a new log that something failed.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public static final void failed( Task task,
                                     Throwable t ) {

        try { 
            
            TaskLog log = new TaskLog();
            log.setIdentifier( task.getIdentifier() );
            log.setStatus( STATUS_FAILED );
            log.setMessage( t.getMessage() );
            log.setExceptionClassname( t.getClass().getName() );

            log.setTask( task.getClass().getName() );
            
            //FIXME: include the stack trace.
            
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            t.printStackTrace( new PrintStream( bos ) );
            
            log.setExceptionStacktrace( bos.toString() );
            
            log.save();
            
        } catch ( Throwable t2 ) { }
        
    }

}

