package org.openprivacy.reptile.om;

// JDK classes
import java.util.*;

// Village classes
import com.workingdogs.village.*;

// Turbine classes
import org.apache.turbine.om.peer.*;
import org.apache.turbine.util.*;
import org.apache.turbine.util.db.*;
import org.apache.turbine.util.db.map.*;
import org.apache.turbine.util.db.pool.DBConnection;

// Local classes
import org.openprivacy.reptile.om.map.*;

/** 
  * The skeleton for this class was autogenerated by Torque on:
  *
  * [Tue Feb 19 16:40:51 PST 2002]
  *
  *  You should add additional methods to this class to meet the
  *  application requirements.  This class will only be generated as
  *  long as it does not already exist in the output directory.
  */
public class SettingPeer 
    extends org.openprivacy.reptile.om.BaseSettingPeer
{

    /**
     * Get a setting by name
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     */
    public static Setting getSetting( String name ) throws Exception {
        
        Criteria criteria = new Criteria();

        criteria.add( SettingPeer.NAME, name );

        Vector v = doSelect( criteria );

        if ( v.size() == 0 ) {

            Setting s = new Setting();
            s.setName( name );
            return s;

        }

        if ( v.size() == 1)
            return (Setting)v.elementAt( 0 );

        throw new Exception( "Too many settings found.  Name column needs to be unique." );
        
    }

}

