package org.openprivacy.reptile.om;

// JDK classes
import java.util.*;

// Village classes
import com.workingdogs.village.*;

// Turbine classes
import org.apache.turbine.om.peer.*;
import org.apache.turbine.util.*;
import org.apache.turbine.util.db.*;
import org.apache.turbine.util.db.map.*;
import org.apache.turbine.util.db.pool.DBConnection;

// Local classes
import org.openprivacy.reptile.om.map.*;

/** 
  * The skeleton for this class was autogenerated by Torque on:
  *
  * [Sun Mar 17 02:07:49 PST 2002]
  *
  *  You should add additional methods to this class to meet the
  *  application requirements.  This class will only be generated as
  *  long as it does not already exist in the output directory.
  */
public class PeerAdvertisementPeer 
    extends org.openprivacy.reptile.om.BasePeerAdvertisementPeer
{

    /**
     * Get the number of advs in this peer.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: PeerAdvertisementPeer.java,v 1.2 2002/03/18 09:23:20 burton Exp $
     */
    public static int getCount() throws Exception {

        //Criteria crit = new Criteria().addAsColumn("count", "count(*)");

        //now get the count back...

        Vector v = BasePeer.executeQuery( "SELECT COUNT(*) FROM " + TABLE_NAME + ";" );

        Record record = (Record)v.elementAt( 0 );
        return record.getValue( 1 ).asInt();
        
    }

    /**
     * Get a PeerAdvertisement by it's AdvertisementID return null if one wasn't found.  
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: PeerAdvertisementPeer.java,v 1.2 2002/03/18 09:23:20 burton Exp $
     */
    public static PeerAdvertisement getPeerAdvertisementByAdvertisementID( String advertisementID ) throws Exception {
        
        Criteria criteria = new Criteria();

        criteria.add( PeerAdvertisementPeer.ADVERTISEMENT_ID, advertisementID );

        Vector v = doSelect( criteria );

        if ( v.size() == 0 )
            return null;

        if ( v.size() == 1)
            return (PeerAdvertisement)v.elementAt( 0 );

        throw new Exception( "Too many advs found." );
        
    }

    /**
     * Get a PeerAdvertisement by it's AdvertisementID return null if one wasn't found.  
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: PeerAdvertisementPeer.java,v 1.2 2002/03/18 09:23:20 burton Exp $
     */
    public static PeerAdvertisement getPeerAdvertisementByPeerID( String peerID ) throws Exception {
        
        Criteria criteria = new Criteria();

        criteria.add( PeerAdvertisementPeer.PEER_ID, peerID );

        Vector v = doSelect( criteria );

        if ( v.size() == 0 )
            return null;

        if ( v.size() == 1)
            return (PeerAdvertisement)v.elementAt( 0 );

        throw new Exception( "Too many advs found." );
        
    }

}

