package org.openprivacy.reptile.om;

// JDK classes
import java.util.*;

// Village classes
import com.workingdogs.village.*;

// Turbine classes
import org.apache.turbine.om.peer.*;
import org.apache.turbine.util.*;
import org.apache.turbine.util.db.*;
import org.apache.turbine.util.db.map.*;
import org.apache.turbine.util.db.pool.DBConnection;

// Local classes
import org.openprivacy.reptile.om.map.*;

/** 
  * The skeleton for this class was autogenerated by Torque on:
  *
  * [Mon Nov 26 01:04:40 PST 2001]
  *
  *  You should add additional methods to this class to meet the
  *  application requirements.  This class will only be generated as
  *  long as it does not already exist in the output directory.
  */
public class ImagePeer 
    extends org.openprivacy.reptile.om.BaseImagePeer
{

    /**
     * Get a image by it's channel, return null if one wasn't found.  
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: ImagePeer.java,v 1.4 2002/02/26 10:39:57 burton Exp $
     */
    public static Image getImageByChannel( String uChannel ) throws Exception {
        
        Criteria criteria = new Criteria();

        criteria.add( ImagePeer.CHANNEL, uChannel );

        Vector v = doSelect( criteria );

        if ( v.size() == 0 )
            return null;

        if ( v.size() == 1)
            return (Image)v.elementAt( 0 );

        throw new Exception( "Too many results found" );
        
    }

    /**
     * Update the image of the given channel.
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     */
    public static synchronized void updateChannel( String uChannel,
                                                   String uImage,
                                                   String title,
                                                   String description ) throws Exception {

        Image i = getImageByChannel( uChannel );

        if ( i == null ) {

            //we really only need to save once.  I don't know what we should do
            //in the long term WRT mulitple images per channel or updated images
            //on channels.
            
            i = new Image();
            i.setChannel( uChannel );
            i.setLocation( uImage );
            i.setTitle( title );
            i.setDescription( description );
            i.save();

            //now update the channel correctly.
            Channel channel = ChannelPeer.getChannelByLocation( uChannel );

            channel.setImageFk( i.getId() );
            
            channel.save();
            
        }

    }
    
}

