package org.openprivacy.reptile.om;

// JDK classes
import java.util.*;

// Village classes
import com.workingdogs.village.*;

// Turbine classes
import org.apache.turbine.om.peer.*;
import org.apache.turbine.util.*;
import org.apache.turbine.util.db.*;
import org.apache.turbine.util.db.map.*;
import org.apache.turbine.util.db.pool.DBConnection;

// Local classes
import org.openprivacy.reptile.om.map.*;

/** 
  * The skeleton for this class was autogenerated by Torque on:
  *
  * [Mon Nov 26 00:47:53 PST 2001]
  *
  *  You should add additional methods to this class to meet the
  *  application requirements.  This class will only be generated as
  *  long as it does not already exist in the output directory.
  */
public class FeedPeer 
    extends org.openprivacy.reptile.om.BaseFeedPeer
{

    /**
     * Get a channel by it's location return null if one wasn't found.  
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: FeedPeer.java,v 1.2 2001/11/27 02:25:36 burton Exp $
     */
    public static Feed getFeedByLocation( String location ) throws Exception {
        
        Criteria criteria = new Criteria();

        criteria.add( FeedPeer.LOCATION, location );

        criteria.addDescendingOrderByColumn( FeedPeer.DATE_FOUND );
        
        Vector v = doSelect( criteria );

        if ( v.size() == 0 )
            return null;

        if ( v.size() == 1)
            return (Feed)v.elementAt( 0 );

        throw new Exception( "Location column needs to be unique." );
        
    }

}

