package org.openprivacy.reptile.om;

// JDK classes
import java.util.*;

// Village classes
import com.workingdogs.village.*;

// Turbine classes
import org.apache.turbine.om.peer.*;
import org.apache.turbine.util.*;
import org.apache.turbine.util.db.*;
import org.apache.turbine.util.db.map.*;
import org.apache.turbine.util.db.pool.DBConnection;

// Local classes
import org.openprivacy.reptile.om.map.*;

/** 
  * The skeleton for this class was autogenerated by Torque on:
  *
  * [Thu Nov 29 00:21:16 PST 2001]
  *
  *  You should add additional methods to this class to meet the
  *  application requirements.  This class will only be generated as
  *  long as it does not already exist in the output directory.
  */
public class FaviconPeer 
    extends org.openprivacy.reptile.om.BaseFaviconPeer
{

    public static final int STATUS_SUCCESS = 1;
    public static final int STATUS_FAILED = 2;

    /**
     * Get a Favicon by it's location return null if one wasn't found.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: FaviconPeer.java,v 1.2 2001/12/12 09:29:06 burton Exp $
     */
    public static Favicon getFaviconBySite( String site ) throws Exception {
        
        Criteria criteria = new Criteria();

        criteria.add( FaviconPeer.SITE, site );

        Vector v = doSelect( criteria );

        if ( v.size() == 0 )
            return null;

        if ( v.size() == 1)
            return (Favicon)v.elementAt( 0 );

        //should never happen
        throw new Exception( "Too many items found.  Location column needs to be unique." );
        
    }

}

