package org.openprivacy.reptile.om;

// JDK classes
import java.util.*;

// Village classes
import com.workingdogs.village.*;

// Turbine classes
import org.apache.turbine.om.peer.*;
import org.apache.turbine.util.*;
import org.apache.turbine.util.db.*;
import org.apache.turbine.util.db.map.*;
import org.apache.turbine.util.db.pool.DBConnection;

// Local classes
import org.openprivacy.reptile.*;
import org.openprivacy.reptile.om.map.*;

/** 
  * The skeleton for this class was autogenerated by Torque on:
  *
  * [Mon Nov 26 01:04:40 PST 2001]
  *
  *  You should add additional methods to this class to meet the
  *  application requirements.  This class will only be generated as
  *  long as it does not already exist in the output directory.
  */
public class ChannelPeer 
    extends org.openprivacy.reptile.om.BaseChannelPeer
{

    public static final int CHANNEL_UNINITIALIZED = 0;

    public static final int CHANNEL_INITIALIZED = 1;

    public static final int CHANNEL_UNSUBSCRIBED = 0;

    public static final int CHANNEL_SUBSCRIBED = 1;

    /**
     * Get a channel by it's location return null if one wasn't found.  
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: ChannelPeer.java,v 1.11 2002/03/23 21:29:34 burton Exp $
     */
    public static Channel getChannelByLocation( String location ) throws Exception {
        
        Criteria criteria = new Criteria();

        criteria.add( ChannelPeer.LOCATION, location );

        Vector v = doSelect( criteria );

        if ( v.size() == 0 )
            return null;

        if ( v.size() == 1)
            return (Channel)v.elementAt( 0 );

        throw new Exception( "Too many channels found.  Location column needs to be unique." );
        
    }

    /**
     * Return all subscriptions within the given channel.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public static Channel[] getSubscriptionsByCategory( Category category ) throws Exception {

        Criteria criteria = new Criteria();

        criteria.add( ChannelPeer.CATEGORY_FK, category.getId() );
        criteria.add( ChannelPeer.SUBSCRIBED, CHANNEL_SUBSCRIBED );

        criteria.addAscendingOrderByColumn( ChannelPeer.TITLE );
        
        return returnChannels( criteria );
        
    }
    
    /**
     * Update a specific channel with a new content feed.  This make SURE that
     * we don't already have this entry and if it does we just update it.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: ChannelPeer.java,v 1.11 2002/03/23 21:29:34 burton Exp $
     */
    public static void registerChannel( ContentFeed feed ) throws Exception {

        //don't allow feeds with null titles...
        if ( feed.getTitle() == null ) {

            Log.debug( "Feed had a null title: " + feed.getLocation() );

            return;
            
        } 
        
        Channel c = getChannelByLocation( feed.getLocation() );

        if ( c == null ) {

            c = new Channel();
            c.setLocation( feed.getLocation() );
            
        } 

        //only update the valus in the database if the found version is null.

        if ( c.getContentType() == null )
            c.setContentType( feed.getContentType() );

        if ( c.getTitle() == null )
            c.setTitle( feed.getTitle() );

        if ( c.getDescription() == null )
            c.setDescription( feed.getDescription() );

        if ( c.getSource() == null )
            c.setSource( feed.getSource() );

        c.save();
    
    }

    /**
     * Update the title and description in the given location.
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     */
    public static synchronized void updateChannel( String location,
                                                   String site,
                                                   String contentType,
                                                   String title,
                                                   String description ) throws Exception {

        if ( location == null || contentType == null ) {

            throw new Exception( "location or contentType not specified." );
            
        } else {

            Channel c = getChannelByLocation( location );

            if ( c == null ) {

                c = new Channel();
                c.setLocation( location );
            
            } 

            boolean uninitialized = c.getInitialized() == CHANNEL_UNINITIALIZED;
            
            if ( contentType != null || uninitialized ) 
                c.setContentType( contentType );

            if ( title != null || uninitialized ) 
                c.setTitle( title );

            if ( description != null || uninitialized )
                c.setDescription( description );

            if ( site != null || uninitialized )
                c.setSite( site );

            c.setInitialized( CHANNEL_INITIALIZED );

            c.save();

        }

    }
    
    /**
     * Get the number of channels in this peer.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: ChannelPeer.java,v 1.11 2002/03/23 21:29:34 burton Exp $
     */
    public static int getCount() throws Exception {

        //Criteria crit = new Criteria().addAsColumn("count", "count(*)");

        //now get the count back...

        Vector v = BasePeer.executeQuery( "SELECT COUNT(*) FROM " + TABLE_NAME + ";" );

        Record record = (Record)v.elementAt( 0 );
        return record.getValue( 1 ).asInt();
        
    }

    /**
     * Search for and find channels by their title.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: ChannelPeer.java,v 1.11 2002/03/23 21:29:34 burton Exp $
     */
    public static Channel[] searchByTitle( String query ) throws Exception {

        Criteria criteria = new Criteria();

        criteria.add( ChannelPeer.TITLE, (Object)query, Criteria.LIKE );

        criteria.addDescendingOrderByColumn( ChannelPeer.DATE_FOUND );
        
        return returnChannels( criteria );
        
    }

    /**
     * Search for and find channels by their description.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: ChannelPeer.java,v 1.11 2002/03/23 21:29:34 burton Exp $
     */
    public static Channel[] searchByDescription( String query ) throws Exception {

        Criteria criteria = new Criteria();

        criteria.add( ChannelPeer.DESCRIPTION, (Object)query, Criteria.LIKE );

        criteria.addDescendingOrderByColumn( ChannelPeer.DATE_FOUND );
        
        return returnChannels( criteria );
        
    }

    /**
     * Search within the peers by title and description.  
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: ChannelPeer.java,v 1.11 2002/03/23 21:29:34 burton Exp $
     */
    public static Channel[] searchByTitleAndDescription( String query ) throws Exception {

        Criteria crit = new Criteria();

        Criteria.Criterion byTitle = crit.getNewCriterion( TITLE, query, Criteria.LIKE );
        Criteria.Criterion byDescription = crit.getNewCriterion( DESCRIPTION, query, Criteria.LIKE );

        //Need to execute an OR query...

        crit.add( byTitle.or( byDescription ) );

        crit.addDescendingOrderByColumn( ChannelPeer.DATE_FOUND );

        return returnChannels( crit );
        
    }

    /**
     * Get all channel that are SUBSCRIBED
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public static Channel[] getSubscriptions() throws Exception {

        Criteria criteria = new Criteria();

        criteria.add( ChannelPeer.SUBSCRIBED, 1 );

        criteria.addAscendingOrderByColumn( ChannelPeer.TITLE );

        return returnChannels( criteria );
        
    }

    /**
     * Mark all articles within the given channel, read..
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public static void markChannelRead( String location ) throws Exception {

        markChannel( location, ArticlePeer.S_MARKED_READ ); 
        
    }

    /**
     * Mark all articles within the given channel, read..
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public static void markChannelUnread( String location ) throws Exception {

        markChannel( location, ArticlePeer.S_MARKED_UNREAD ); 
        
    }
    
    /**
     * Mark all articles in the given channel with the given mark.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    private static void markChannel( String location, int mark ) throws Exception {

        Criteria selectCriteria = new Criteria();

        selectCriteria.add( ArticlePeer.CHANNEL, location );
        
        Criteria updateCriteria = new Criteria();

        updateCriteria.add( ArticlePeer.MARKED_READ, mark );
        
        ArticlePeer.doUpdate( selectCriteria, updateCriteria );

    }

    /**
     * Get the default subscription.  This is usually the first subscription on the 
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public static Channel getDefaultSubscription() {

        //first we need to get the category lowest on the alphabet

        Criteria catc = new Criteria();
        
        catc.addAscendingOrderByColumn( CategoryPeer.NAME );
        catc.setLimit( 1  ); //we only need the first one..

        //FIXME: need an impl of this.
        
        return null;
        
    }
    
    /**
     * Given a vector of channels... return it as an array of channels.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: ChannelPeer.java,v 1.11 2002/03/23 21:29:34 burton Exp $
     */
    private static Channel[] returnChannels( Criteria crit ) throws Exception {
        
        Vector v = doSelect( crit );

        Channel[] channels = new Channel[ v.size() ];

        v.copyInto( channels );

        return channels;

    }

}

