package org.openprivacy.reptile.om;

// JDK classes
import java.util.*;

// Village classes
import com.workingdogs.village.*;

// Turbine classes
import org.apache.turbine.om.peer.*;
import org.apache.turbine.util.*;
import org.apache.turbine.util.db.*;
import org.apache.turbine.util.db.map.*;
import org.apache.turbine.util.db.pool.DBConnection;

// Local classes
import org.openprivacy.reptile.om.map.*;

/** 
  * The skeleton for this class was autogenerated by Torque on:
  *
  * [Sun Feb 24 13:53:57 PST 2002]
  *
  *  You should add additional methods to this class to meet the
  *  application requirements.  This class will only be generated as
  *  long as it does not already exist in the output directory.
  */
public class CategoryPeer 
    extends org.openprivacy.reptile.om.BaseCategoryPeer
{

    /**
     * Get a category by its name return null if one wasn't found.  
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: CategoryPeer.java,v 1.3 2002/02/25 23:50:08 burton Exp $
     */
    public static Category getCategoryByName( String name ) throws Exception {
        
        Criteria criteria = new Criteria();

        criteria.add( CategoryPeer.NAME, name );

        Vector v = doSelect( criteria );

        if ( v.size() == 0 )
            return null;

        if ( v.size() == 1)
            return (Category)v.elementAt( 0 );

        throw new Exception( "Too many categories found.  Name column needs to be unique." );
        
    }

    /**
     * Return all categories...
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public static Category[] getCategories() throws Exception {

        Criteria crit = new Criteria();

        crit.addAscendingOrderByColumn( CategoryPeer.NAME );
        
        return returnCategory( crit );
        
    }

    /**
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     */
    private static Category[] returnCategory( Criteria crit ) throws Exception {
        
        Vector v = doSelect( crit );

        Category[] result = new Category[ v.size() ];

        v.copyInto( result );

        return result;

    }

    
}

