package org.openprivacy.reptile.om;


// JDK classes
import java.util.*;
import java.math.*;

// Turbine classes
import org.apache.turbine.om.*;
import org.apache.turbine.om.peer.BasePeer;
import org.apache.turbine.util.db.Criteria;
import org.apache.turbine.util.ObjectUtils;
import org.apache.turbine.util.StringUtils;
import org.apache.turbine.util.ParameterParser;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.db.pool.DBConnection;

/** 
 * This class was autogenerated by Torque on:
 *
 * [Mon Jul 01 17:54:11 PDT 2002]
 *
 * You should not use this class directly.  It should not even be
 * extended all references should be to Setting 
 */
public abstract class BaseSetting extends BaseObject
    implements Retrievable
{
          /** the value for the id field */
    private NumberKey id;
          /** the value for the name field */
    private String name;
          /** the value for the value field */
    private String value;
  

      /**
     * Get the Id
     * @return NumberKey
     */
     public NumberKey getId()
     {
          return id;
     }

                            
    /**
     * Set the value of Id
     */
     public void setId(NumberKey v ) 
     {
  
  

         if ( !ObjectUtils.equals(this.id, v) )
        {
                       if (this.id == null)
            {
                this.id = new NumberKey(v);
            }
            else
            {
                this.id.setValue(v);
            }
                      setModified(true);
        }
     }

     /**
    * Set the value of Id as a string.
    */
    public void setId(String v ) 
    {
         setId(new NumberKey(v));
    }
  
    /**
     * Get the Name
     * @return String
     */
     public String getName()
     {
          return name;
     }

                            
    /**
     * Set the value of Name
     */
     public void setName(String v ) 
     {
  
  

         if ( !ObjectUtils.equals(this.name, v) )
        {
                       this.name = v;
                      setModified(true);
        }
     }

  
    /**
     * Get the Value
     * @return String
     */
     public String getValue()
     {
          return value;
     }

                            
    /**
     * Set the value of Value
     */
     public void setValue(String v ) 
     {
  
  

         if ( !ObjectUtils.equals(this.value, v) )
        {
                       this.value = v;
                      setModified(true);
        }
     }

  

 
    
        
    
    private static Vector fieldNames_ = null;

    /**
     * Generate a list of field names.
     */
    public static synchronized List getFieldNames()
    {
      if (fieldNames_ == null)
      {
        fieldNames_ = new Vector();
            fieldNames_.add("Id");
            fieldNames_.add("Name");
            fieldNames_.add("Value");
          }
      return fieldNames_;
    }

    /**
     * Retrieves a field from the object by name passed in
     * as a String.
     */
    public Object getByName(String name)
    {
            if (name.equals("Id"))
	{
	  	    return getId();
	  	}
            if (name.equals("Name"))
	{
	  	    return getName();
	  	}
            if (name.equals("Value"))
	{
	  	    return getValue();
	  	}
            return null; 
    }
    /**
     * Retrieves a field from the object by name passed in
     * as a String.  The String must be one of the static
     * Strings defined in this Class' Peer.
     */
    public Object getByPeerName(String name)
    {
            if (name.equals(SettingPeer.ID ))
	    {
	  	    return getId();
	  	}
            if (name.equals(SettingPeer.NAME ))
	    {
	  	    return getName();
	  	}
            if (name.equals(SettingPeer.VALUE ))
	    {
	  	    return getValue();
	  	}
            return null; 
    }

    /**
     * Retrieves a field from the object by Position as specified
     * in the xml schema.  Zero-based.
     */
    public Object getByPosition(int pos)
    {
            if ( pos == 0 )
	{
	  	    return getId();
	  	}
            if ( pos == 1 )
	{
	  	    return getName();
	  	}
            if ( pos == 2 )
	{
	  	    return getValue();
	  	}
                return null; 
    }

     	

    /**
     * Stores the object in the database.  If the object is new,
     * it inserts it; otherwise an update is performed.
     */
    public void save() throws Exception
    {
             save(SettingPeer.getMapBuilder()
                .getDatabaseMap().getName());
     }

    /**
     * Stores the object in the database.  If the object is new,
     * it inserts it; otherwise an update is performed.
     */
    public void save(String dbName) throws Exception
    {
        DBConnection dbCon = null;
         try
        {
            dbCon = BasePeer.beginTransaction(dbName);
            save(dbCon);
        }
        catch(Exception e)
        {
            BasePeer.rollBackTransaction(dbCon);
            throw e;
        }
        BasePeer.commitTransaction(dbCon);

     }

      // flag to prevent endless save loop, if this object is referenced
    // by another object which falls in this transaction.
    private boolean alreadyInSave = false;
      /**
     * Stores the object in the database.  If the object is new,
     * it inserts it; otherwise an update is performed.  This method
     * is meant to be used as part of a transaction, otherwise use
     * the save() method and the connection details will be handled
     * internally
     */
    public void save(DBConnection dbCon) throws Exception
    {
        if (!alreadyInSave)
      {
        alreadyInSave = true;
          if (isModified())
        {
            if (isNew())
            {
                SettingPeer.doInsert((Setting)this, dbCon);
            }
            else
            {
                SettingPeer.doUpdate((Setting)this, dbCon);
                setNew(false);
            }
        }

              alreadyInSave = false;
      }
      }


                
    
    

        /** 
     * Set the PrimaryKey using ObjectKey.
     *
     * @param ObjectKey id
     */
    public void setPrimaryKey(ObjectKey id) 
         {
         setId((NumberKey)id);
    }

    /** 
     * Set the PrimaryKey using a String.
     */
    public void setPrimaryKey(String key) 
    {
        setId(new NumberKey(key) );
    }



    /** 
     * returns an id that differentiates this object from others
     * of its class.
     */
    public ObjectKey getPrimaryKey() 
    {
        return getId();
    }

 
    /** 
     * get an id that differentiates this object from others
     * of its class.
     */
    public String getQueryKey() 
    {
        if (getPrimaryKey() == null)
        {
            return "";
        }
        else
        {
            return getPrimaryKey().toString();
        }
    }

    /** 
     * set an id that differentiates this object from others
     * of its class.
     */
    public void setQueryKey(String key) 
        throws Exception
    {
        setPrimaryKey(key);
    }

    /**
     * Makes a copy of this object.  
     * It creates a new object filling in the simple attributes.
     * It then fills all the association collections and sets the
     * related objects to isNew=true.
     */
    public Setting copy() throws Exception
    {
        Setting copyObj = new Setting();
        copyObj.setId(id);
        copyObj.setName(name);
        copyObj.setValue(value);


    
            copyObj.setId((NumberKey)null);
                    return copyObj;
    }
}

