package org.openprivacy.reptile.om;

// JDK classes
import java.util.*;
import java.math.*;
import java.sql.*;

// Village classes
import com.workingdogs.village.*;

// Turbine classes
import org.apache.turbine.om.*;
import org.apache.turbine.om.peer.*;
import org.apache.turbine.util.*;
import org.apache.turbine.util.db.*;
import org.apache.turbine.util.db.map.*;
import org.apache.turbine.util.db.pool.DBConnection;
import org.apache.turbine.services.db.TurbineDB;

// Local classes
import org.openprivacy.reptile.om.map.*;

/**
  * This class was autogenerated by Torque on:
  *
  * [Mon Jul 01 17:54:11 PDT 2002]
  *
  */
public abstract class BaseMonitorPeer 
    extends BasePeer
{

    /** the mapbuilder for this class */
    private static final MonitorMapBuilder mapBuilder = 
        (MonitorMapBuilder)getMapBuilder(MonitorMapBuilder.CLASS_NAME);

    /** the table name for this class */
    public static final String TABLE_NAME = mapBuilder.getTable();

    /** 
     * @returns the map builder for this peer 
     */
    public static MapBuilder getMapBuilder()
    {
       return(mapBuilder);
    }

    /** the column name for the ID field */
    public static final String ID = mapBuilder.getMonitor_Id();
    /** the column name for the CHANNEL_FK field */
    public static final String CHANNEL_FK = mapBuilder.getMonitor_ChannelFk();

 
    /** number of columns for this peer */
    public static final int numColumns =  2;

    /** A class that can be returned by this peer. */
    protected static final String CLASSNAME_DEFAULT = 
        "org.openprivacy.reptile.om.Monitor";

    /** A class that can be returned by this peer. */
    protected static final Class CLASS_DEFAULT = initClass();

    /** Initialization method for static CLASS_DEFAULT attribute */
    private static Class initClass()
    {
        Class c = null;
        try
        { 
            c = Class.forName(CLASSNAME_DEFAULT);
        }
        catch (Exception e)
        {
            Log.error("A FATAL ERROR has occurred which should not" +
                "have happened under any circumstance.  Please notify" +
                "Turbine and give as many details as possible including the " +
                "error stacktrace.", e);
        }
        return c;
    }


    /**
     * Get the list of objects for a ResultSet.  Please not that your
     * resultset MUST return columns in the right order.  You can use
     * getFieldNames() in BaseObject to get the correct sequence.
     */
    public static Vector resultSet2Objects (java.sql.ResultSet results) throws Exception
    {
        QueryDataSet qds = null;
        Vector rows = null;
        try
        {
            qds = new QueryDataSet( results );
            rows = getSelectResults( qds );
        }
        finally
        {
            if (qds != null) qds.close();
        }

        return populateObjects (rows);

    }



    /** Method to do inserts */
    public static ObjectKey doInsert( Criteria criteria ) throws Exception
    {
            criteria.setDbName(mapBuilder.getDatabaseMap().getName());
                                             return BasePeer.doInsert( criteria );
    }

    /** 
     * Method to do inserts.  This method is to be used during a transaction,
     * otherwise use the doInsert(Criteria) method.  It will take care of 
     * the connection details internally. 
     */
    public static ObjectKey doInsert( Criteria criteria, DBConnection dbCon ) 
        throws Exception
    {
            criteria.setDbName(mapBuilder.getDatabaseMap().getName());
                                             return BasePeer.doInsert( criteria, dbCon );
    }

    /** Add all the columns needed to create a new object */
    public static void addSelectColumns (Criteria criteria) throws Exception
    {
            criteria.addSelectColumn( ID );
            criteria.addSelectColumn( CHANNEL_FK );
        }


    /** 
     * Create a new object of type cls from a resultset row starting
     * from a specified offset.  This is done so that you can select
     * other rows than just those needed for this object.  You may
     * for example want to create two objects from the same row.
     */
    public static Monitor row2Object (Record row, 
                                              int offset, 
                                              Class cls ) 
        throws Exception
    {
        Monitor obj = (Monitor)cls.newInstance();
        populateObject(row, offset, obj);
                    obj.setModified(false);
                obj.setNew(false);

        return obj;
    }

    /** 
     * Populates an object from a resultset row starting
     * from a specified offset.  This is done so that you can select
     * other rows than just those needed for this object.  You may
     * for example want to create two objects from the same row.
     */
    public static void populateObject (Record row, 
                                       int offset, 
                                       Monitor obj ) 
        throws Exception
    {
                                                        obj.setId(
                new NumberKey(row.getValue(offset+0).asBigDecimal()));
                                                                            obj.setChannelFk(
                new NumberKey(row.getValue(offset+1).asBigDecimal()));
                                        }

    /** Method to do selects */
    public static Vector doSelect( Criteria criteria ) throws Exception
    {
        return populateObjects( doSelectVillageRecords(criteria) ); 
    }


    /** Method to do selects within a transaction */
    public static Vector doSelect( Criteria criteria, 
                                   DBConnection dbCon ) 
        throws Exception
    {
        return populateObjects( doSelectVillageRecords(criteria, dbCon) ); 
    }

    /** 
     * Grabs the raw Village records to be formed into objects.
     * This method handles connections internally.  The Record objects
     * returned by this method should be considered readonly.  Do not
     * alter the data and call save(), your results may vary, but are
     * certainly likely to result in hard to track MT bugs.
     */
    public static Vector doSelectVillageRecords( Criteria criteria ) 
        throws Exception
    {
            criteria.setDbName(mapBuilder.getDatabaseMap().getName());
            if (criteria.getSelectColumns().size() == 0)
        {
            addSelectColumns ( criteria );
        }

                                 
        // BasePeer returns a Vector of Value (Village) arrays.  The array
        // order follows the order columns were placed in the Select clause.
        return BasePeer.doSelect(criteria);
    }


    /** 
     * Grabs the raw Village records to be formed into objects.
     * This method should be used for transactions 
     */
    public static Vector doSelectVillageRecords( Criteria criteria, 
                                                 DBConnection dbCon ) 
        throws Exception
    {
        if (criteria.getSelectColumns().size() == 0)
        {
            addSelectColumns ( criteria );
        }

                                 
        // BasePeer returns a Vector of Value (Village) arrays.  The array
        // order follows the order columns were placed in the Select clause.
        return BasePeer.doSelect(criteria, dbCon);
    }

    /** 
     * The returned vector will contain objects of the default type or
     * objects that inherit from the default.
     */
    public static Vector populateObjects(Vector records) 
        throws Exception
    {
        Vector results = new Vector(records.size());

        // populate the object(s)
        for ( int i=0; i<records.size(); i++ )
        {
            Record row = (Record)records.elementAt(i);
            results.add(MonitorPeer.row2Object(row, 1,
                MonitorPeer.getOMClass()));
        }
        return results;
    }
 

    /** 
     * The class that the Peer will make instances of. 
     * If the BO is abstract then you must implement this method
     * in the BO.
     */
    public static Class getOMClass() 
        throws Exception
    {
            return CLASS_DEFAULT;
        }


    /**
     * Method to do updates. 
     *
     * @param Criteria object containing data that is used to create the UPDATE statement.
     */
    public static void doUpdate(Criteria criteria) throws Exception
    {
            criteria.setDbName(mapBuilder.getDatabaseMap().getName());
            Criteria selectCriteria = new
            Criteria(mapBuilder.getDatabaseMap().getName(), 2);
                                selectCriteria.put( ID, criteria.remove(ID) );
                                         selectCriteria.put( CHANNEL_FK, criteria.remove(CHANNEL_FK) );
                       BasePeer.doUpdate( selectCriteria, criteria );
    }

    /** 
     * Method to do updates.  This method is to be used during a transaction,
     * otherwise use the doUpdate(Criteria) method.  It will take care of 
     * the connection details internally. 
     *
     * @param Criteria object containing data that is used to create the UPDATE statement.
     */
    public static void doUpdate(Criteria criteria, DBConnection dbCon) throws Exception
    {
            criteria.setDbName(mapBuilder.getDatabaseMap().getName());
            Criteria selectCriteria = new
            Criteria(mapBuilder.getDatabaseMap().getName(), 2);
                                selectCriteria.put( ID, criteria.remove(ID) );
                                         selectCriteria.put( CHANNEL_FK, criteria.remove(CHANNEL_FK) );
                       BasePeer.doUpdate( selectCriteria, criteria, dbCon );
     }

    /** 
     * Method to do deletes.
     *
     * @param Criteria object containing data that is used DELETE from database.
     */
     public static void doDelete(Criteria criteria) throws Exception
     {
            criteria.setDbName(mapBuilder.getDatabaseMap().getName());
                                              BasePeer.doDelete ( criteria );
     }

    /** 
     * Method to do deletes.  This method is to be used during a transaction,
     * otherwise use the doDelete(Criteria) method.  It will take care of 
     * the connection details internally. 
     *
     * @param Criteria object containing data that is used DELETE from database.
     */
     public static void doDelete(Criteria criteria, DBConnection dbCon) throws Exception
     {
            criteria.setDbName(mapBuilder.getDatabaseMap().getName());
                                              BasePeer.doDelete ( criteria, dbCon );
     }

    /** Method to do inserts */
    public static void doInsert( Monitor obj ) throws Exception
    {
                doInsert(buildCriteria(obj));
                obj.setNew(false);
    }

    /**
     * @param obj the data object to update in the database.
     */
    public static void doUpdate(Monitor obj) throws Exception
    {
        doUpdate(buildCriteria(obj));
    }
    /**
     * @param obj the data object to delete in the database.
     */
    public static void doDelete(Monitor obj) throws Exception
    {
        doDelete(buildCriteria(obj));
    }

    /** 
     * Method to do inserts.  This method is to be used during a transaction,
     * otherwise use the doInsert(Monitor) method.  It will take 
     * care of the connection details internally. 
     *
     * @param obj the data object to insert into the database.
     */
    public static void doInsert( Monitor obj, DBConnection dbCon) throws Exception
    {
                doInsert(buildCriteria(obj), dbCon);
                obj.setNew(false);
    }

    /**
     * Method to do update.  This method is to be used during a transaction,
     * otherwise use the doUpdate(Monitor) method.  It will take 
     * care of the connection details internally. 
     *
     * @param obj the data object to update in the database.
     */
    public static void doUpdate(Monitor obj, DBConnection dbCon) throws Exception
    {
        doUpdate(buildCriteria(obj), dbCon);
    }
    /**
     * Method to delete.  This method is to be used during a transaction,
     * otherwise use the doDelete(Monitor) method.  It will take 
     * care of the connection details internally. 
     *
     * @param obj the data object to delete in the database.
     */
    public static void doDelete(Monitor obj, DBConnection dbCon) throws Exception
    {
        doDelete(buildCriteria(obj), dbCon);
    }

    /** Build a Criteria object from the data object for this peer */
    public static Criteria buildCriteria( Monitor obj )
    {
        Criteria criteria = new Criteria();
                                criteria.add( ID, obj.getId() );
                                criteria.add( CHANNEL_FK, obj.getChannelFk() );
                return criteria;
    }

    /** 
     * Retrieve a single object by pk
     *
     * @param ObjectKey pk
     */
    public static Monitor retrieveByPK( ObjectKey pk )
        throws Exception
    {
        DBConnection db = null;
        Monitor retVal = null;
       try
        {
           db = TurbineDB.getConnection( mapBuilder.getDatabaseMap().getName() );
           retVal = retrieveByPK( pk, db );
        }
        finally
        {
           if (db != null)
              TurbineDB.releaseConnection(db);
        }
        return(retVal);
    }

    /** 
     * Retrieve a single object by pk
     *
     * @param ObjectKey pk
     * @param DBConnection dbcon
     */
    public static Monitor retrieveByPK( ObjectKey pk, DBConnection dbcon )
        throws Exception
    {

        Criteria criteria = new Criteria();
        SimpleKey[] keys = (SimpleKey[])pk.getValue();
                    criteria.add( ID, keys[0] );
                        criteria.add( CHANNEL_FK, keys[1] );
                    Vector v = doSelect(criteria, dbcon);
        if ( v.size() != 1)
        {
            throw new Exception("Failed to select one and only one row.");
        }
        else
        {
            return (Monitor)v.firstElement();
        }
    }


    /** 
     * retrieve object using using pk values.
     *
     * @param NumberKey id
     * @param NumberKey channel_fk
     */
    public static Monitor retrieveByPK(
     NumberKey id
            , NumberKey channel_fk
                ) throws Exception
    {
        DBConnection db = null;
        Monitor retVal = null;
       try
        {
           db = TurbineDB.getConnection( mapBuilder.getDatabaseMap().getName() );
           retVal = retrieveByPK( 
                                id
                                  , channel_fk
                                        , db);
        }
        finally
        {
           if (db != null)
              TurbineDB.releaseConnection(db);
        }
        return(retVal);
    }   

    /** 
     * retrieve object using using pk values.
     *
     * @param NumberKey id
     * @param NumberKey channel_fk
     * @param DBConnection dbcon
     */
    public static Monitor retrieveByPK(
     NumberKey id
            , NumberKey channel_fk
               ,DBConnection dbcon ) throws Exception
    {
    
        Criteria criteria = new Criteria(5);
        criteria.add( ID, id );
        criteria.add( CHANNEL_FK, channel_fk );
        Vector v = doSelect(criteria, dbcon);
        if ( v.size() != 1)
        {
            throw new Exception("Failed to select one and only one row.");
        }
        else
        {
            return (Monitor) v.firstElement();
        }
    }

 

     
        
                       
     
          


   /**
    * selects a collection of Monitor objects pre-filled with their
    * Channel objects.
    */
    protected static Vector doSelectJoinChannel(Criteria c)
        throws Exception
    {
         c.setDbName(mapBuilder.getDatabaseMap().getName());

        MonitorPeer.addSelectColumns(c);
        int offset = numColumns + 1;
        ChannelPeer.addSelectColumns(c);


                  c.addJoin(MonitorPeer.CHANNEL_FK,
            ChannelPeer.ID);
     



                                         
        Vector rows = BasePeer.doSelect(c);
        Vector results = new Vector();

        for (int i=0; i<rows.size(); i++)
        {
            Record row = (Record)rows.elementAt(i);

            Class omClass = MonitorPeer.getOMClass();

            Monitor obj1 = (Monitor)MonitorPeer
                .row2Object( row, 1, omClass);


             omClass = ChannelPeer.getOMClass();
            Channel obj2 = (Channel)ChannelPeer
                .row2Object(row, offset, omClass);
            
            boolean newObject = true;
            for (int j=0; j<results.size(); j++)
            {
                Monitor temp_obj1 = (Monitor)results.elementAt(j);
                Channel temp_obj2 = temp_obj1.getChannel();
                if ( temp_obj2.getPrimaryKey().equals(obj2.getPrimaryKey() ) )
                {
                    newObject = false;
                    temp_obj2.addMonitor(obj1);
                    break;
                }
            }
            if (newObject)
            {
                obj2.initMonitors();
                obj2.addMonitor(obj1);
            }
            results.add(obj1);

        }

        return results;
    }
    

  


    /** 
     * Returns the TableMap related to this peer.  This method is not 
     * needed for general use but a specific application could have a
     * need.
     */
    protected static TableMap getTableMap()
    {
        return mapBuilder.getDatabaseMap().getTable(TABLE_NAME);
    }     
 

}

