package org.openprivacy.reptile.om;


// JDK classes
import java.util.*;
import java.math.*;

// Turbine classes
import org.apache.turbine.om.*;
import org.apache.turbine.om.peer.BasePeer;
import org.apache.turbine.util.db.Criteria;
import org.apache.turbine.util.ObjectUtils;
import org.apache.turbine.util.StringUtils;
import org.apache.turbine.util.ParameterParser;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.db.pool.DBConnection;

/** 
 * This class was autogenerated by Torque on:
 *
 * [Mon Jul 01 17:54:11 PDT 2002]
 *
 * You should not use this class directly.  It should not even be
 * extended all references should be to Monitor 
 */
public abstract class BaseMonitor extends BaseObject
    implements Retrievable
{
          /** the value for the id field */
    private NumberKey id;
          /** the value for the channel_fk field */
    private NumberKey channel_fk;
  

      /**
     * Get the Id
     * @return NumberKey
     */
     public NumberKey getId()
     {
          return id;
     }

                            
    /**
     * Set the value of Id
     */
     public void setId(NumberKey v ) 
     {
  
  

         if ( !ObjectUtils.equals(this.id, v) )
        {
                       if (this.id == null)
            {
                this.id = new NumberKey(v);
            }
            else
            {
                this.id.setValue(v);
            }
                      setModified(true);
        }
     }

     /**
    * Set the value of Id as a string.
    */
    public void setId(String v ) 
    {
         setId(new NumberKey(v));
    }
  
    /**
     * Get the ChannelFk
     * @return NumberKey
     */
     public NumberKey getChannelFk()
     {
          return channel_fk;
     }

                                    
    /**
     * Set the value of ChannelFk
     */
     public void setChannelFk(NumberKey v ) throws Exception
     {
              aChannel = null;
  
  

         if ( !ObjectUtils.equals(this.channel_fk, v) )
        {
                       if (this.channel_fk == null)
            {
                this.channel_fk = new NumberKey(v);
            }
            else
            {
                this.channel_fk.setValue(v);
            }
                      setModified(true);
        }
     }

     /**
    * Set the value of ChannelFk as a string.
    */
    public void setChannelFk(String v ) throws Exception
    {
         setChannelFk(new NumberKey(v));
    }
  

 
 
   
             
   
   
    private Channel aChannel;

    /**
     * Declares an association between this object and a Channel object
     *
     * @param Channel v
     */
    public void setChannel(Channel v) throws Exception
    {
           setChannelFk(v.getId());
           aChannel = v;
    }

                     
    public Channel getChannel() throws Exception
    {
        if ( aChannel==null && (!ObjectUtils.equals(this.channel_fk, null)) )
        {
            aChannel = ChannelPeer.retrieveByPK(this.channel_fk);
            // The following can be used instead of the line above to
            // guarantee the related object contains a reference
            // to this object, but this level of coupling 
            // may be undesirable in many circumstances.
            // As it can lead to a db query with many results that may
            // never be used.  
            // Channel obj = ChannelPeer.retrieveByPK(this.channel_fk);
            // obj.addMonitors(this);
        }
        return aChannel;
    }


    /**
     * Provides convenient way to set a relationship based on a 
     * ObjectKey.  e.g. 
     * <code>bar.setFooKey(foo.getPrimaryKey())</code>
     *
     */
    public void setChannelKey(ObjectKey key) throws Exception
    {
            setChannelFk((NumberKey)key);        
        }

    
        
    
    private static Vector fieldNames_ = null;

    /**
     * Generate a list of field names.
     */
    public static synchronized List getFieldNames()
    {
      if (fieldNames_ == null)
      {
        fieldNames_ = new Vector();
            fieldNames_.add("Id");
            fieldNames_.add("ChannelFk");
          }
      return fieldNames_;
    }

    /**
     * Retrieves a field from the object by name passed in
     * as a String.
     */
    public Object getByName(String name)
    {
            if (name.equals("Id"))
	{
	  	    return getId();
	  	}
            if (name.equals("ChannelFk"))
	{
	  	    return getChannelFk();
	  	}
            return null; 
    }
    /**
     * Retrieves a field from the object by name passed in
     * as a String.  The String must be one of the static
     * Strings defined in this Class' Peer.
     */
    public Object getByPeerName(String name)
    {
            if (name.equals(MonitorPeer.ID ))
	    {
	  	    return getId();
	  	}
            if (name.equals(MonitorPeer.CHANNEL_FK ))
	    {
	  	    return getChannelFk();
	  	}
            return null; 
    }

    /**
     * Retrieves a field from the object by Position as specified
     * in the xml schema.  Zero-based.
     */
    public Object getByPosition(int pos)
    {
            if ( pos == 0 )
	{
	  	    return getId();
	  	}
            if ( pos == 1 )
	{
	  	    return getChannelFk();
	  	}
                return null; 
    }

     	

    /**
     * Stores the object in the database.  If the object is new,
     * it inserts it; otherwise an update is performed.
     */
    public void save() throws Exception
    {
             save(MonitorPeer.getMapBuilder()
                .getDatabaseMap().getName());
     }

    /**
     * Stores the object in the database.  If the object is new,
     * it inserts it; otherwise an update is performed.
     */
    public void save(String dbName) throws Exception
    {
        DBConnection dbCon = null;
         try
        {
            dbCon = BasePeer.beginTransaction(dbName);
            save(dbCon);
        }
        catch(Exception e)
        {
            BasePeer.rollBackTransaction(dbCon);
            throw e;
        }
        BasePeer.commitTransaction(dbCon);

     }

      // flag to prevent endless save loop, if this object is referenced
    // by another object which falls in this transaction.
    private boolean alreadyInSave = false;
      /**
     * Stores the object in the database.  If the object is new,
     * it inserts it; otherwise an update is performed.  This method
     * is meant to be used as part of a transaction, otherwise use
     * the save() method and the connection details will be handled
     * internally
     */
    public void save(DBConnection dbCon) throws Exception
    {
        if (!alreadyInSave)
      {
        alreadyInSave = true;
          if (isModified())
        {
            if (isNew())
            {
                MonitorPeer.doInsert((Monitor)this, dbCon);
            }
            else
            {
                MonitorPeer.doUpdate((Monitor)this, dbCon);
                setNew(false);
            }
        }

              alreadyInSave = false;
      }
      }


                
    
                            
    
    

    private final SimpleKey[] pks = new SimpleKey[2];
    private final ComboKey comboPK = new ComboKey(pks);
    /** 
     * Set the PrimaryKey with an ObjectKey
     */
    public void setPrimaryKey(ObjectKey key) throws Exception
    {
        SimpleKey[] keys = (SimpleKey[])key.getValue();
                    setId((NumberKey)keys[0]);
                        setChannelFk((NumberKey)keys[1]);
                }

    /** 
     * Set the PrimaryKey using SimpleKeys.
     *
     * @param NumberKey id
     * @param NumberKey channel_fk
     */
    public void setPrimaryKey( NumberKey id, NumberKey channel_fk) 
        throws Exception {
         setId(id);
         setChannelFk(channel_fk);
    }

    /** 
     * Set the PrimaryKey with Strings.
     *
     * @param String id
     * @param String channel_fk
     */
    public void setPrimaryKey( String id, String channel_fk) 
        throws Exception {
         setId(new NumberKey(id));
         setChannelFk(new NumberKey(channel_fk));
    }

    /** 
     * Set the PrimaryKey using a String.
     */
    public void setPrimaryKey(String key) throws Exception
    {
        int prevPos = 0;

                  int colonPos = key.indexOf(':', prevPos);
        setId( new NumberKey(key.substring(prevPos, colonPos)) );
        prevPos = colonPos + 1;
                     colonPos = key.indexOf(':', prevPos);
        setChannelFk( new NumberKey(key.substring(prevPos, colonPos)) );
        prevPos = colonPos + 1;
                 }



    /** 
     * returns an id that differentiates this object from others
     * of its class.
     */
    public ObjectKey getPrimaryKey() 
    {
            pks[0] = getId();
                    pks[1] = getChannelFk();
                    return comboPK;
    }

 
    /** 
     * get an id that differentiates this object from others
     * of its class.
     */
    public String getQueryKey() 
    {
        if (getPrimaryKey() == null)
        {
            return "";
        }
        else
        {
            return getPrimaryKey().toString();
        }
    }

    /** 
     * set an id that differentiates this object from others
     * of its class.
     */
    public void setQueryKey(String key) 
        throws Exception
    {
        setPrimaryKey(key);
    }

    /**
     * Makes a copy of this object.  
     * It creates a new object filling in the simple attributes.
     * It then fills all the association collections and sets the
     * related objects to isNew=true.
     */
    public Monitor copy() throws Exception
    {
        Monitor copyObj = new Monitor();
        copyObj.setId(id);
        copyObj.setChannelFk(channel_fk);


    
            copyObj.setId((NumberKey)null);
                copyObj.setChannelFk((NumberKey)null);
            return copyObj;
    }
}

