package org.openprivacy.reptile.om;


// JDK classes
import java.util.*;
import java.math.*;

// Turbine classes
import org.apache.turbine.om.*;
import org.apache.turbine.om.peer.BasePeer;
import org.apache.turbine.util.db.Criteria;
import org.apache.turbine.util.ObjectUtils;
import org.apache.turbine.util.StringUtils;
import org.apache.turbine.util.ParameterParser;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.db.pool.DBConnection;

/** 
 * This class was autogenerated by Torque on:
 *
 * [Mon Jul 01 17:54:11 PDT 2002]
 *
 * You should not use this class directly.  It should not even be
 * extended all references should be to Image 
 */
public abstract class BaseImage extends BaseObject
    implements Retrievable
{
          /** the value for the id field */
    private NumberKey id;
          /** the value for the channel field */
    private String channel;
          /** the value for the location field */
    private String location;
          /** the value for the width field */
    private int width;
          /** the value for the height field */
    private int height;
          /** the value for the title field */
    private String title;
          /** the value for the description field */
    private String description;
  

      /**
     * Get the Id
     * @return NumberKey
     */
     public NumberKey getId()
     {
          return id;
     }

                                                            
    /**
     * Set the value of Id
     */
     public void setId(NumberKey v ) throws Exception
     {
  
       
        
                
          // update associated Channel
          if (collChannels != null )
          {
              for (int i=0; i<collChannels.size(); i++)
              {
                  ((Channel)collChannels.get(i))
                      .setImageFk(v);
              }
          }
       

         if ( !ObjectUtils.equals(this.id, v) )
        {
                       if (this.id == null)
            {
                this.id = new NumberKey(v);
            }
            else
            {
                this.id.setValue(v);
            }
                      setModified(true);
        }
     }

     /**
    * Set the value of Id as a string.
    */
    public void setId(String v ) throws Exception
    {
         setId(new NumberKey(v));
    }
  
    /**
     * Get the Channel
     * @return String
     */
     public String getChannel()
     {
          return channel;
     }

                            
    /**
     * Set the value of Channel
     */
     public void setChannel(String v ) 
     {
  
  

         if ( !ObjectUtils.equals(this.channel, v) )
        {
                       this.channel = v;
                      setModified(true);
        }
     }

  
    /**
     * Get the Location
     * @return String
     */
     public String getLocation()
     {
          return location;
     }

                            
    /**
     * Set the value of Location
     */
     public void setLocation(String v ) 
     {
  
  

         if ( !ObjectUtils.equals(this.location, v) )
        {
                       this.location = v;
                      setModified(true);
        }
     }

  
    /**
     * Get the Width
     * @return int
     */
     public int getWidth()
     {
          return width;
     }

                            
    /**
     * Set the value of Width
     */
     public void setWidth(int v ) 
     {
  
  

         if (this.width != v)
        {
                       this.width = v;
                      setModified(true);
        }
     }

  
    /**
     * Get the Height
     * @return int
     */
     public int getHeight()
     {
          return height;
     }

                            
    /**
     * Set the value of Height
     */
     public void setHeight(int v ) 
     {
  
  

         if (this.height != v)
        {
                       this.height = v;
                      setModified(true);
        }
     }

  
    /**
     * Get the Title
     * @return String
     */
     public String getTitle()
     {
          return title;
     }

                            
    /**
     * Set the value of Title
     */
     public void setTitle(String v ) 
     {
  
  

         if ( !ObjectUtils.equals(this.title, v) )
        {
                       this.title = v;
                      setModified(true);
        }
     }

  
    /**
     * Get the Description
     * @return String
     */
     public String getDescription()
     {
          return description;
     }

                            
    /**
     * Set the value of Description
     */
     public void setDescription(String v ) 
     {
  
  

         if ( !ObjectUtils.equals(this.description, v) )
        {
                       this.description = v;
                      setModified(true);
        }
     }

  

 
    
                
      
    /**
     * Collection to store aggregation of collChannels
     */
    protected Vector collChannels;
    /**
     * Temporary storage of collChannels to save a possible db hit in
     * the event objects are add to the collection, but the
     * complete collection is never requested.
     */
//    private Vector tempcollChannels;

    protected void initChannels()
    {
        if (collChannels == null)
            collChannels = new Vector();
    }

    /**
     * Method called to associate a Channel object to this object
     * through the Channel foreign key attribute
     *
     * @param Channel l
     */
    public void addChannel(Channel l) throws Exception
    {
        /*
        if (collChannels == null)
        {
            if (tempcollChannels == null)
            {
                tempcollChannels = new Vector();
            }
            tempcollChannels.add(l);
        }
        else
        {
            collChannels.add(l);
        }
        */
        getChannels().add(l);
        l.setImage((Image)this);
    }

    /**
     * The criteria used to select the current contents of collChannels
     */
    private Criteria lastChannelsCriteria = null;

    /**
     * If this collection has already been initialized, returns
     * the collection. Otherwise returns the results of 
     * getChannels(new Criteria())
     */
    public Vector getChannels() throws Exception
    {
        if (collChannels == null)
        {
            collChannels = getChannels(new Criteria(10));
        }
        return collChannels;
    }

    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection. 
     * Otherwise if this Image has previously
     * been saved, it will retrieve related Channels from storage.
     * If this Image is new, it will return
     * an empty collection or the current collection, the criteria
     * is ignored on a new object. 
     */
    public Vector getChannels(Criteria criteria) throws Exception
    {
        if (collChannels == null)
        {
            if ( isNew() ) 
            {
               collChannels = new Vector();       
            } 
            else
            {
                   criteria.add(ChannelPeer.IMAGE_FK, getId() );               
                   collChannels = ChannelPeer.doSelect(criteria);
            }
/*
            if (tempcollChannels != null)
            {
                for (int i=0; i<tempcollChannels.size(); i++)
                {
                    collChannels.add(tempcollChannels.get(i));
                }
                tempcollChannels = null;
            }
*/
        }
        else
        {
           // criteria has no effect for a new object
            if ( !isNew() ) 
            {
                // the following code is to determine if a new query is
                // called for.  If the criteria is the same as the last
                // one, just return the collection.
                   criteria.add(ChannelPeer.IMAGE_FK, getId() );               
                   if ( !lastChannelsCriteria.equals(criteria)  )
                {
                    collChannels = ChannelPeer.doSelect(criteria);  
                }
            }
        }
        lastChannelsCriteria = criteria; 

        return collChannels;
    }
    

        
      
         
          
                    
                
        
        
       
      
      
          
                    
                
        
        
   
    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection. 
     * Otherwise if this Image is new, it will return
     * an empty collection; or if this Image has previously
     * been saved, it will retrieve related Channels from storage.
     */
    protected Vector getChannelsJoinCategory(Criteria criteria) 
        throws Exception
    {
        if (collChannels == null)
        {
            if ( isNew() ) 
            {
               collChannels = new Vector();       
            } 
            else
            {
                   criteria.add(ChannelPeer.IMAGE_FK, getId() );               
                   collChannels = ChannelPeer.doSelectJoinCategory(criteria);
            }
            
            
        }
        else
        {
            // the following code is to determine if a new query is
            // called for.  If the criteria is the same as the last
            // one, just return the collection.
            boolean newCriteria = true;
                   criteria.add(ChannelPeer.IMAGE_FK, getId() );               
               if ( !lastChannelsCriteria.equals(criteria)  )
            {
                collChannels = ChannelPeer.doSelectJoinCategory(criteria);
            }
        }
        lastChannelsCriteria = criteria; 

        return collChannels;
    }
     



     
    
    private static Vector fieldNames_ = null;

    /**
     * Generate a list of field names.
     */
    public static synchronized List getFieldNames()
    {
      if (fieldNames_ == null)
      {
        fieldNames_ = new Vector();
            fieldNames_.add("Id");
            fieldNames_.add("Channel");
            fieldNames_.add("Location");
            fieldNames_.add("Width");
            fieldNames_.add("Height");
            fieldNames_.add("Title");
            fieldNames_.add("Description");
          }
      return fieldNames_;
    }

    /**
     * Retrieves a field from the object by name passed in
     * as a String.
     */
    public Object getByName(String name)
    {
            if (name.equals("Id"))
	{
	  	    return getId();
	  	}
            if (name.equals("Channel"))
	{
	  	    return getChannel();
	  	}
            if (name.equals("Location"))
	{
	  	    return getLocation();
	  	}
            if (name.equals("Width"))
	{
	  	    return new Integer(getWidth());
	  	}
            if (name.equals("Height"))
	{
	  	    return new Integer(getHeight());
	  	}
            if (name.equals("Title"))
	{
	  	    return getTitle();
	  	}
            if (name.equals("Description"))
	{
	  	    return getDescription();
	  	}
            return null; 
    }
    /**
     * Retrieves a field from the object by name passed in
     * as a String.  The String must be one of the static
     * Strings defined in this Class' Peer.
     */
    public Object getByPeerName(String name)
    {
            if (name.equals(ImagePeer.ID ))
	    {
	  	    return getId();
	  	}
            if (name.equals(ImagePeer.CHANNEL ))
	    {
	  	    return getChannel();
	  	}
            if (name.equals(ImagePeer.LOCATION ))
	    {
	  	    return getLocation();
	  	}
            if (name.equals(ImagePeer.WIDTH ))
	    {
	  	    return new Integer(getWidth());
	  	}
            if (name.equals(ImagePeer.HEIGHT ))
	    {
	  	    return new Integer(getHeight());
	  	}
            if (name.equals(ImagePeer.TITLE ))
	    {
	  	    return getTitle();
	  	}
            if (name.equals(ImagePeer.DESCRIPTION ))
	    {
	  	    return getDescription();
	  	}
            return null; 
    }

    /**
     * Retrieves a field from the object by Position as specified
     * in the xml schema.  Zero-based.
     */
    public Object getByPosition(int pos)
    {
            if ( pos == 0 )
	{
	  	    return getId();
	  	}
            if ( pos == 1 )
	{
	  	    return getChannel();
	  	}
            if ( pos == 2 )
	{
	  	    return getLocation();
	  	}
            if ( pos == 3 )
	{
	  	    return new Integer(getWidth());
	  	}
            if ( pos == 4 )
	{
	  	    return new Integer(getHeight());
	  	}
            if ( pos == 5 )
	{
	  	    return getTitle();
	  	}
            if ( pos == 6 )
	{
	  	    return getDescription();
	  	}
                return null; 
    }

     	

    /**
     * Stores the object in the database.  If the object is new,
     * it inserts it; otherwise an update is performed.
     */
    public void save() throws Exception
    {
             save(ImagePeer.getMapBuilder()
                .getDatabaseMap().getName());
     }

    /**
     * Stores the object in the database.  If the object is new,
     * it inserts it; otherwise an update is performed.
     */
    public void save(String dbName) throws Exception
    {
        DBConnection dbCon = null;
         try
        {
            dbCon = BasePeer.beginTransaction(dbName);
            save(dbCon);
        }
        catch(Exception e)
        {
            BasePeer.rollBackTransaction(dbCon);
            throw e;
        }
        BasePeer.commitTransaction(dbCon);

     }

      // flag to prevent endless save loop, if this object is referenced
    // by another object which falls in this transaction.
    private boolean alreadyInSave = false;
      /**
     * Stores the object in the database.  If the object is new,
     * it inserts it; otherwise an update is performed.  This method
     * is meant to be used as part of a transaction, otherwise use
     * the save() method and the connection details will be handled
     * internally
     */
    public void save(DBConnection dbCon) throws Exception
    {
        if (!alreadyInSave)
      {
        alreadyInSave = true;
          if (isModified())
        {
            if (isNew())
            {
                ImagePeer.doInsert((Image)this, dbCon);
            }
            else
            {
                ImagePeer.doUpdate((Image)this, dbCon);
                setNew(false);
            }
        }

                                    
                
          if (collChannels != null )
          {
              for (int i=0; i<collChannels.size(); i++)
              {
                  ((Channel)collChannels.get(i)).save(dbCon);
              }
          }
                  alreadyInSave = false;
      }
      }


                        
    
    

        /** 
     * Set the PrimaryKey using ObjectKey.
     *
     * @param ObjectKey id
     */
    public void setPrimaryKey(ObjectKey id) 
        throws Exception {
         setId((NumberKey)id);
    }

    /** 
     * Set the PrimaryKey using a String.
     */
    public void setPrimaryKey(String key) throws Exception
    {
        setId(new NumberKey(key) );
    }



    /** 
     * returns an id that differentiates this object from others
     * of its class.
     */
    public ObjectKey getPrimaryKey() 
    {
        return getId();
    }

 
    /** 
     * get an id that differentiates this object from others
     * of its class.
     */
    public String getQueryKey() 
    {
        if (getPrimaryKey() == null)
        {
            return "";
        }
        else
        {
            return getPrimaryKey().toString();
        }
    }

    /** 
     * set an id that differentiates this object from others
     * of its class.
     */
    public void setQueryKey(String key) 
        throws Exception
    {
        setPrimaryKey(key);
    }

    /**
     * Makes a copy of this object.  
     * It creates a new object filling in the simple attributes.
     * It then fills all the association collections and sets the
     * related objects to isNew=true.
     */
    public Image copy() throws Exception
    {
        Image copyObj = new Image();
        copyObj.setId(id);
        copyObj.setChannel(channel);
        copyObj.setLocation(location);
        copyObj.setWidth(width);
        copyObj.setHeight(height);
        copyObj.setTitle(title);
        copyObj.setDescription(description);


                                    
                
         List v = copyObj.getChannels();
         for (int i=0; i<v.size(); i++)
         {
             ((Persistent)v.get(i)).setNew(true);
         }
              
            copyObj.setId((NumberKey)null);
                                    return copyObj;
    }
}

