package org.openprivacy.reptile.om;


// JDK classes
import java.util.*;
import java.math.*;

// Turbine classes
import org.apache.turbine.om.*;
import org.apache.turbine.om.peer.BasePeer;
import org.apache.turbine.util.db.Criteria;
import org.apache.turbine.util.ObjectUtils;
import org.apache.turbine.util.StringUtils;
import org.apache.turbine.util.ParameterParser;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.db.pool.DBConnection;

/** 
 * This class was autogenerated by Torque on:
 *
 * [Mon Jul 01 17:54:11 PDT 2002]
 *
 * You should not use this class directly.  It should not even be
 * extended all references should be to Feed 
 */
public abstract class BaseFeed extends BaseObject
    implements Retrievable
{
          /** the value for the id field */
    private NumberKey id;
          /** the value for the location field */
    private String location;
          /** the value for the content_type field */
    private String content_type;
          /** the value for the date_found field */
    private long date_found;
          /** the value for the last_updated field */
    private long last_updated;
          /** the value for the copyright field */
    private String copyright;
  

      /**
     * Get the Id
     * @return NumberKey
     */
     public NumberKey getId()
     {
          return id;
     }

                            
    /**
     * Set the value of Id
     */
     public void setId(NumberKey v ) 
     {
  
  

         if ( !ObjectUtils.equals(this.id, v) )
        {
                       if (this.id == null)
            {
                this.id = new NumberKey(v);
            }
            else
            {
                this.id.setValue(v);
            }
                      setModified(true);
        }
     }

     /**
    * Set the value of Id as a string.
    */
    public void setId(String v ) 
    {
         setId(new NumberKey(v));
    }
  
    /**
     * Get the Location
     * @return String
     */
     public String getLocation()
     {
          return location;
     }

                            
    /**
     * Set the value of Location
     */
     public void setLocation(String v ) 
     {
  
  

         if ( !ObjectUtils.equals(this.location, v) )
        {
                       this.location = v;
                      setModified(true);
        }
     }

  
    /**
     * Get the ContentType
     * @return String
     */
     public String getContentType()
     {
          return content_type;
     }

                            
    /**
     * Set the value of ContentType
     */
     public void setContentType(String v ) 
     {
  
  

         if ( !ObjectUtils.equals(this.content_type, v) )
        {
                       this.content_type = v;
                      setModified(true);
        }
     }

  
    /**
     * Get the DateFound
     * @return long
     */
     public long getDateFound()
     {
          return date_found;
     }

                            
    /**
     * Set the value of DateFound
     */
     public void setDateFound(long v ) 
     {
  
  

         if (this.date_found != v)
        {
                       this.date_found = v;
                      setModified(true);
        }
     }

  
    /**
     * Get the LastUpdated
     * @return long
     */
     public long getLastUpdated()
     {
          return last_updated;
     }

                            
    /**
     * Set the value of LastUpdated
     */
     public void setLastUpdated(long v ) 
     {
  
  

         if (this.last_updated != v)
        {
                       this.last_updated = v;
                      setModified(true);
        }
     }

  
    /**
     * Get the Copyright
     * @return String
     */
     public String getCopyright()
     {
          return copyright;
     }

                            
    /**
     * Set the value of Copyright
     */
     public void setCopyright(String v ) 
     {
  
  

         if ( !ObjectUtils.equals(this.copyright, v) )
        {
                       this.copyright = v;
                      setModified(true);
        }
     }

  

 
    
        
    
    private static Vector fieldNames_ = null;

    /**
     * Generate a list of field names.
     */
    public static synchronized List getFieldNames()
    {
      if (fieldNames_ == null)
      {
        fieldNames_ = new Vector();
            fieldNames_.add("Id");
            fieldNames_.add("Location");
            fieldNames_.add("ContentType");
            fieldNames_.add("DateFound");
            fieldNames_.add("LastUpdated");
            fieldNames_.add("Copyright");
          }
      return fieldNames_;
    }

    /**
     * Retrieves a field from the object by name passed in
     * as a String.
     */
    public Object getByName(String name)
    {
            if (name.equals("Id"))
	{
	  	    return getId();
	  	}
            if (name.equals("Location"))
	{
	  	    return getLocation();
	  	}
            if (name.equals("ContentType"))
	{
	  	    return getContentType();
	  	}
            if (name.equals("DateFound"))
	{
	  	    return new Long(getDateFound());
	  	}
            if (name.equals("LastUpdated"))
	{
	  	    return new Long(getLastUpdated());
	  	}
            if (name.equals("Copyright"))
	{
	  	    return getCopyright();
	  	}
            return null; 
    }
    /**
     * Retrieves a field from the object by name passed in
     * as a String.  The String must be one of the static
     * Strings defined in this Class' Peer.
     */
    public Object getByPeerName(String name)
    {
            if (name.equals(FeedPeer.ID ))
	    {
	  	    return getId();
	  	}
            if (name.equals(FeedPeer.LOCATION ))
	    {
	  	    return getLocation();
	  	}
            if (name.equals(FeedPeer.CONTENT_TYPE ))
	    {
	  	    return getContentType();
	  	}
            if (name.equals(FeedPeer.DATE_FOUND ))
	    {
	  	    return new Long(getDateFound());
	  	}
            if (name.equals(FeedPeer.LAST_UPDATED ))
	    {
	  	    return new Long(getLastUpdated());
	  	}
            if (name.equals(FeedPeer.COPYRIGHT ))
	    {
	  	    return getCopyright();
	  	}
            return null; 
    }

    /**
     * Retrieves a field from the object by Position as specified
     * in the xml schema.  Zero-based.
     */
    public Object getByPosition(int pos)
    {
            if ( pos == 0 )
	{
	  	    return getId();
	  	}
            if ( pos == 1 )
	{
	  	    return getLocation();
	  	}
            if ( pos == 2 )
	{
	  	    return getContentType();
	  	}
            if ( pos == 3 )
	{
	  	    return new Long(getDateFound());
	  	}
            if ( pos == 4 )
	{
	  	    return new Long(getLastUpdated());
	  	}
            if ( pos == 5 )
	{
	  	    return getCopyright();
	  	}
                return null; 
    }

     	

    /**
     * Stores the object in the database.  If the object is new,
     * it inserts it; otherwise an update is performed.
     */
    public void save() throws Exception
    {
             save(FeedPeer.getMapBuilder()
                .getDatabaseMap().getName());
     }

    /**
     * Stores the object in the database.  If the object is new,
     * it inserts it; otherwise an update is performed.
     */
    public void save(String dbName) throws Exception
    {
        DBConnection dbCon = null;
         try
        {
            dbCon = BasePeer.beginTransaction(dbName);
            save(dbCon);
        }
        catch(Exception e)
        {
            BasePeer.rollBackTransaction(dbCon);
            throw e;
        }
        BasePeer.commitTransaction(dbCon);

     }

      // flag to prevent endless save loop, if this object is referenced
    // by another object which falls in this transaction.
    private boolean alreadyInSave = false;
      /**
     * Stores the object in the database.  If the object is new,
     * it inserts it; otherwise an update is performed.  This method
     * is meant to be used as part of a transaction, otherwise use
     * the save() method and the connection details will be handled
     * internally
     */
    public void save(DBConnection dbCon) throws Exception
    {
        if (!alreadyInSave)
      {
        alreadyInSave = true;
          if (isModified())
        {
            if (isNew())
            {
                FeedPeer.doInsert((Feed)this, dbCon);
            }
            else
            {
                FeedPeer.doUpdate((Feed)this, dbCon);
                setNew(false);
            }
        }

              alreadyInSave = false;
      }
      }


                
    
    

        /** 
     * Set the PrimaryKey using ObjectKey.
     *
     * @param ObjectKey id
     */
    public void setPrimaryKey(ObjectKey id) 
         {
         setId((NumberKey)id);
    }

    /** 
     * Set the PrimaryKey using a String.
     */
    public void setPrimaryKey(String key) 
    {
        setId(new NumberKey(key) );
    }



    /** 
     * returns an id that differentiates this object from others
     * of its class.
     */
    public ObjectKey getPrimaryKey() 
    {
        return getId();
    }

 
    /** 
     * get an id that differentiates this object from others
     * of its class.
     */
    public String getQueryKey() 
    {
        if (getPrimaryKey() == null)
        {
            return "";
        }
        else
        {
            return getPrimaryKey().toString();
        }
    }

    /** 
     * set an id that differentiates this object from others
     * of its class.
     */
    public void setQueryKey(String key) 
        throws Exception
    {
        setPrimaryKey(key);
    }

    /**
     * Makes a copy of this object.  
     * It creates a new object filling in the simple attributes.
     * It then fills all the association collections and sets the
     * related objects to isNew=true.
     */
    public Feed copy() throws Exception
    {
        Feed copyObj = new Feed();
        copyObj.setId(id);
        copyObj.setLocation(location);
        copyObj.setContentType(content_type);
        copyObj.setDateFound(date_found);
        copyObj.setLastUpdated(last_updated);
        copyObj.setCopyright(copyright);


    
            copyObj.setId((NumberKey)null);
                                return copyObj;
    }
}

